/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonArrayImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonLongImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonNumberImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonStringImpl;

class JsonArrayBuilderImpl
implements JsonArrayBuilder,
Serializable {
    private List<JsonValue> tmpList;

    JsonArrayBuilderImpl() {
    }

    public JsonArrayBuilder add(JsonValue value) {
        this.addValue(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        this.addValue((JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        this.addValue((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        this.addValue((JsonValue)new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.addValue((JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.addValue((JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.addValue((JsonValue)new JsonDoubleImpl(value));
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.addValue(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.addValue(JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.addValue((JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.addValue((JsonValue)builder.build());
        return this;
    }

    private void addValue(JsonValue value) {
        if (value == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<JsonValue>();
        }
        this.tmpList.add(value);
    }

    public JsonArray build() {
        if (this.tmpList == null) {
            return new JsonArrayImpl(Collections.EMPTY_LIST);
        }
        List<JsonValue> dump = Collections.unmodifiableList(this.tmpList);
        this.tmpList = null;
        return new JsonArrayImpl(dump);
    }

    private static NullPointerException npe() {
        throw new NullPointerException("value/builder must not be null");
    }
}

