/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.ArrayList;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SparseArrayLinkedListTest {
    private static final int SPARSE_ARRAY_CAPACITY = 4;
    private static final int ELEMENTS = 16;
    private final SparseArrayLinkedList<Integer> list = new SparseArrayLinkedList(4);

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateZeroArrayCapacityCollection() {
        new SparseArrayLinkedList(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateNegativeArrayCapacityCollection() {
        new SparseArrayLinkedList(-1);
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailToAddNull() {
        this.list.add(null);
    }

    @Test
    public void shouldNumberOfElementsBeTheSameOfTheAddedElements() {
        int elements = 16;
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((long)i, (long)this.list.size());
            this.list.add((Object)i);
        }
        Assert.assertEquals((long)16L, (long)this.list.size());
    }

    @Test
    public void shouldClearConsumeElementsInOrder() {
        int elements = 16;
        Assert.assertEquals((long)0L, (long)this.list.clear(null));
        ArrayList<Integer> expected = new ArrayList<Integer>(16);
        for (int i = 0; i < 16; ++i) {
            Integer added = i;
            this.list.add((Object)added);
            expected.add(added);
        }
        ArrayList removed = new ArrayList(16);
        Assert.assertEquals((long)16L, (long)this.list.clear(removed::add));
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        Assert.assertEquals((long)0L, (long)this.list.size());
        Assert.assertThat(removed, (Matcher)Is.is(expected));
    }

    @Test
    public void shouldRemoveMatchingElements() {
        int elements = 16;
        for (int i = 0; i < 16; ++i) {
            this.list.add((Object)i);
        }
        Assert.assertEquals((long)1L, (long)this.list.remove(e -> e == 0));
        Assert.assertEquals((long)15L, (long)this.list.size());
        Assert.assertEquals((long)0L, (long)this.list.remove(e -> e == 0));
        Assert.assertEquals((long)15L, (long)this.list.size());
        Assert.assertEquals((long)15L, (long)this.list.remove(e -> true));
        Assert.assertEquals((long)0L, (long)this.list.size());
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        Assert.assertEquals((long)0L, (long)this.list.remove(e -> true));
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
    }

    @Test
    public void shouldRemoveDetachSparseArrays() {
        int elements = this.list.sparseArrayCapacity() * 3;
        for (int i = 0; i < elements; ++i) {
            this.list.add((Object)i);
        }
        int startInclusiveMiddle = this.list.sparseArrayCapacity();
        int endNotInclusiveMiddle = startInclusiveMiddle + this.list.sparseArrayCapacity();
        Assert.assertEquals((long)this.list.sparseArrayCapacity(), (long)this.list.remove(e -> e >= startInclusiveMiddle && e < endNotInclusiveMiddle));
        Assert.assertEquals((long)2L, (long)this.list.sparseArraysCount());
        boolean startInclusiveFirst = false;
        int endNotInclusiveFirst = startInclusiveMiddle;
        Assert.assertEquals((long)this.list.sparseArrayCapacity(), (long)this.list.remove(e -> e >= 0 && e < endNotInclusiveFirst));
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        int startInclusiveLast = endNotInclusiveMiddle;
        int endNotInclusiveLast = elements;
        Assert.assertEquals((long)this.list.sparseArrayCapacity(), (long)this.list.remove(e -> e >= startInclusiveLast && e < endNotInclusiveLast));
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
    }

    @Test
    public void shouldAddAfterRemoveAtTheEndReusingTheAvailableSpace() {
        int elements = this.list.sparseArrayCapacity();
        for (int i = 0; i < elements; ++i) {
            this.list.add((Object)i);
        }
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        Assert.assertEquals((long)1L, (long)this.list.remove(e -> e == elements - 1));
        this.list.add((Object)(elements - 1));
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        Assert.assertEquals((long)1L, (long)this.list.remove(e -> e == 0));
        this.list.add((Object)elements);
        Assert.assertEquals((long)2L, (long)this.list.sparseArraysCount());
    }

    @Test
    public void shouldReuseAllTheAvailableSpaceInTheSameArray() {
        int i;
        int elements = this.list.sparseArrayCapacity();
        for (i = 0; i < elements; ++i) {
            this.list.add((Object)i);
        }
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        Assert.assertEquals((long)elements, (long)this.list.remove(e -> true));
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
        for (i = 0; i < elements; ++i) {
            this.list.add((Object)i);
        }
        Assert.assertEquals((long)1L, (long)this.list.sparseArraysCount());
    }

    @Test
    public void shouldClearConsumeRemainingElementsInOrder() {
        int elements = 16;
        Integer zero = 0;
        this.list.add((Object)zero);
        for (int i = 1; i < 16; ++i) {
            this.list.add((Object)i);
        }
        Assert.assertEquals((long)15L, (long)this.list.remove(e -> e != zero));
        ArrayList remaining = new ArrayList();
        Assert.assertEquals((long)1L, (long)this.list.clear(remaining::add));
        Assert.assertEquals((long)0L, (long)this.list.size());
        Assert.assertEquals((long)1L, (long)remaining.size());
        Assert.assertEquals((Object)zero, remaining.get(0));
    }
}

