/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.ConcurrentModificationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.junit.Assert;
import org.junit.Test;

public class TypedPropertiesConcurrencyTest {
    @Test
    public void testClearAndToString() throws Exception {
        TypedProperties props = new TypedProperties();
        ExecutorService executorService = Executors.newFixedThreadPool(1000);
        AtomicBoolean hasError = new AtomicBoolean();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        int i = 0;
        while (i < 10000) {
            int g = i++;
            executorService.submit(() -> {
                try {
                    countDownLatch.await();
                    for (int h = 0; h < 100; ++h) {
                        props.putSimpleStringProperty(SimpleString.toSimpleString((String)("S" + h)), SimpleString.toSimpleString((String)"hello"));
                    }
                    props.clear();
                }
                catch (ConcurrentModificationException t) {
                    hasError.set(true);
                    t.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        for (i = 0; i < 10; ++i) {
            executorService.submit(() -> {
                try {
                    countDownLatch.await();
                    for (int k = 0; k < 1000; ++k) {
                        Assert.assertNotNull((Object)props.toString());
                    }
                }
                catch (ConcurrentModificationException t) {
                    hasError.set(true);
                    t.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        countDownLatch.countDown();
        Thread.sleep(1000L);
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        executorService.shutdown();
        Assert.assertFalse((boolean)hasError.get());
    }

    @Test
    public void testGetPropertyNamesClearAndToString() throws Exception {
        TypedProperties props = new TypedProperties();
        ExecutorService executorService = Executors.newFixedThreadPool(1000);
        AtomicBoolean hasError = new AtomicBoolean();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        int i = 0;
        while (i < 10000) {
            int g = i++;
            executorService.submit(() -> {
                try {
                    countDownLatch.await();
                    for (int h = 0; h < 100; ++h) {
                        props.putSimpleStringProperty(SimpleString.toSimpleString((String)("S" + h)), SimpleString.toSimpleString((String)"hello"));
                    }
                    props.getPropertyNames().clear();
                }
                catch (UnsupportedOperationException h) {
                }
                catch (ConcurrentModificationException t) {
                    hasError.set(true);
                    t.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        for (i = 0; i < 10; ++i) {
            executorService.submit(() -> {
                try {
                    countDownLatch.await();
                    for (int k = 0; k < 1000; ++k) {
                        Assert.assertNotNull((Object)props.toString());
                    }
                }
                catch (ConcurrentModificationException t) {
                    hasError.set(true);
                    t.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        countDownLatch.countDown();
        Thread.sleep(1000L);
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        executorService.shutdown();
        Assert.assertFalse((boolean)hasError.get());
    }

    @Test
    public void testEncodedSizeAfterClearIsSameAsNewTypedProperties() throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(SimpleString.toSimpleString((String)"helllllloooooo"), SimpleString.toSimpleString((String)"raaaaaaaaaaaaaaaaaaaaaaaa"));
        props.clear();
        Assert.assertEquals((long)new TypedProperties().getEncodeSize(), (long)props.getEncodeSize());
    }

    @Test
    public void testMemoryOffsetAfterClearIsSameAsNewTypedProperties() throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(SimpleString.toSimpleString((String)"helllllloooooo"), SimpleString.toSimpleString((String)"raaaaaaaaaaaaaaaaaaaaaaaa"));
        props.clear();
        Assert.assertEquals((long)new TypedProperties().getMemoryOffset(), (long)props.getMemoryOffset());
    }
}

