/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MaskPasswordResolvingTest {
    private static final String plainPassword = "password";
    private static final String defaultMaskPassword = "defaultmasked";
    private static final String customizedCodecPassword = "secret";
    private static final String oldDefaultMaskedPassword = "oldmasked";
    private static final String oldCustomizedCodecPassword = "secret";
    private static final String oldExplicitPlainPassword = "PASSWORD";
    private Boolean maskPassword;
    private String password;
    private String codec;

    @Parameterized.Parameters(name="mask({0})password({1})codec({2})")
    public static Collection<Object[]> params() {
        return Arrays.asList({null, plainPassword, null}, {null, "ENC(3bdfd94fe8cdf710e7fefa72f809ea90)", null}, {null, "ENC(momsword)", "org.apache.activemq.artemis.utils.MaskPasswordResolvingTest$SimplePasswordCodec"}, {true, "662d05f5a83f9e073af6b8dc081d34aa", null}, {true, "momsword", "org.apache.activemq.artemis.utils.MaskPasswordResolvingTest$SimplePasswordCodec"}, {false, oldExplicitPlainPassword, null}, {false, oldExplicitPlainPassword, "org.apache.activemq.artemis.utils.MaskPasswordResolvingTest$SimplePasswordCodec"});
    }

    public MaskPasswordResolvingTest(Boolean maskPassword, String password, String codec) {
        this.maskPassword = maskPassword;
        this.password = password;
        this.codec = codec;
    }

    @Test
    public void testPasswordResolving() throws Exception {
        String resolved = PasswordMaskingUtil.resolveMask((Boolean)this.maskPassword, (String)this.password, (String)this.codec);
        this.checkResult(resolved);
    }

    private void checkResult(String resolved) throws Exception {
        if (this.maskPassword == null) {
            if (PasswordMaskingUtil.isEncMasked((String)this.password)) {
                if (this.codec != null) {
                    Assert.assertEquals((Object)"secret", (Object)resolved);
                } else {
                    Assert.assertEquals((Object)defaultMaskPassword, (Object)resolved);
                }
            } else {
                Assert.assertEquals((Object)plainPassword, (Object)resolved);
            }
        } else if (this.maskPassword.booleanValue()) {
            if (this.codec != null) {
                Assert.assertEquals((Object)"secret", (Object)resolved);
            } else {
                Assert.assertEquals((Object)oldDefaultMaskedPassword, (Object)resolved);
            }
        } else {
            Assert.assertEquals((Object)oldExplicitPlainPassword, (Object)resolved);
        }
    }

    public static class SimplePasswordCodec
    implements SensitiveDataCodec<String> {
        private Map<String, String> passwordBook = new HashMap<String, String>();

        public SimplePasswordCodec() {
            this.passwordBook.put("momsword", "secret");
            this.passwordBook.put("youneverknow", "keypass");
            this.passwordBook.put("youcanguess", "trustpass");
        }

        public String decode(Object mask) throws Exception {
            String password = this.passwordBook.get(mask);
            if (password == null) {
                throw new IllegalArgumentException("I don't know the password " + mask);
            }
            return password;
        }

        public String encode(Object secret) throws Exception {
            return null;
        }
    }
}

