/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.targets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class TargetKeyResolver {
    public static final String DEFAULT_KEY_VALUE = "DEFAULT";
    private static final Logger logger = Logger.getLogger(TargetKeyResolver.class);
    private static final char SOCKET_ADDRESS_DELIMITER = ':';
    private static final String SOCKET_ADDRESS_PREFIX = "/";
    private final TargetKey key;
    private final Pattern keyFilter;

    public TargetKey getKey() {
        return this.key;
    }

    public String getKeyFilter() {
        return this.keyFilter != null ? this.keyFilter.pattern() : null;
    }

    public TargetKeyResolver(TargetKey key, String keyFilter) {
        this.key = key;
        this.keyFilter = keyFilter != null ? Pattern.compile(keyFilter) : null;
    }

    public String resolve(Connection connection, String clientID, String username) {
        Matcher keyMatcher;
        String keyValue = null;
        switch (this.key) {
            case CLIENT_ID: {
                keyValue = clientID;
                break;
            }
            case SNI_HOST: {
                if (connection == null) break;
                keyValue = connection.getSNIHostName();
                break;
            }
            case SOURCE_IP: {
                if (connection == null || connection.getRemoteAddress() == null) break;
                keyValue = connection.getRemoteAddress();
                boolean hasPrefix = keyValue.startsWith(SOCKET_ADDRESS_PREFIX);
                int delimiterIndex = keyValue.lastIndexOf(58);
                if (!hasPrefix && delimiterIndex <= 0) break;
                keyValue = keyValue.substring(hasPrefix ? SOCKET_ADDRESS_PREFIX.length() : 0, delimiterIndex > 0 ? delimiterIndex : keyValue.length());
                break;
            }
            case USER_NAME: {
                keyValue = username;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.key));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("keyValue for %s: %s", (Object)this.key, (Object)keyValue);
        }
        if (keyValue == null) {
            keyValue = DEFAULT_KEY_VALUE;
        } else if (this.keyFilter != null && (keyMatcher = this.keyFilter.matcher(keyValue)).find()) {
            keyValue = keyMatcher.group();
            if (logger.isDebugEnabled()) {
                logger.debugf("keyValue with filter %s: %s", (Object)this.keyFilter, (Object)keyValue);
            }
        }
        return keyValue;
    }
}

