/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.BaseBundler;

public class SenderSendsBundler
extends BaseBundler {
    protected final AtomicInteger num_senders = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message msg) throws Exception {
        this.num_senders.incrementAndGet();
        long size = msg.size();
        this.lock.lock();
        try {
            if (this.count + size >= (long)this.transport.getMaxBundleSize()) {
                this.sendBundledMessages();
            }
            this.addMessage(msg, size);
            if (this.num_senders.decrementAndGet() == 0) {
                this.sendBundledMessages();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

