/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonChars;

class JsonArrayImpl
extends AbstractList<JsonValue>
implements JsonArray,
Serializable {
    private Integer hashCode = null;
    private final List<JsonValue> unmodifieableBackingList;
    private int size = -1;

    JsonArrayImpl(List<JsonValue> backingList) {
        this.unmodifieableBackingList = backingList;
    }

    private <T> T value(int idx, Class<T> type) {
        if (idx > this.unmodifieableBackingList.size()) {
            throw new IndexOutOfBoundsException(idx + "/" + this.unmodifieableBackingList.size());
        }
        return type.cast(this.unmodifieableBackingList.get(idx));
    }

    @Override
    public JsonObject getJsonObject(int index) {
        return this.value(index, JsonObject.class);
    }

    @Override
    public JsonArray getJsonArray(int index) {
        return this.value(index, JsonArray.class);
    }

    @Override
    public JsonNumber getJsonNumber(int index) {
        return this.value(index, JsonNumber.class);
    }

    @Override
    public JsonString getJsonString(int index) {
        return this.value(index, JsonString.class);
    }

    @Override
    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.unmodifieableBackingList;
    }

    @Override
    public String getString(int index) {
        return this.value(index, JsonString.class).getString();
    }

    @Override
    public String getString(int index, String defaultValue) {
        JsonValue val = null;
        int s = this.size;
        if (s == -1) {
            this.size = s = this.unmodifieableBackingList.size();
        }
        if (index > s - 1 || !((val = this.get(index)) instanceof JsonString)) {
            return defaultValue;
        }
        return ((JsonString)JsonString.class.cast(val)).getString();
    }

    @Override
    public int getInt(int index) {
        return this.value(index, JsonNumber.class).intValue();
    }

    @Override
    public int getInt(int index, int defaultValue) {
        JsonValue val = null;
        int s = this.size;
        if (s == -1) {
            this.size = s = this.unmodifieableBackingList.size();
        }
        if (index > s - 1 || !((val = this.get(index)) instanceof JsonNumber)) {
            return defaultValue;
        }
        return ((JsonNumber)JsonNumber.class.cast(val)).intValue();
    }

    @Override
    public boolean getBoolean(int index) {
        JsonValue val = this.value(index, JsonValue.class);
        if (val == JsonValue.TRUE) {
            return true;
        }
        if (val == JsonValue.FALSE) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(int index, boolean defaultValue) {
        int s = this.size;
        if (s == -1) {
            this.size = s = this.unmodifieableBackingList.size();
        }
        if (index > s - 1) {
            return defaultValue;
        }
        JsonValue val = this.get(index);
        if (val == JsonValue.TRUE) {
            return true;
        }
        if (val == JsonValue.FALSE) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean isNull(int index) {
        return this.value(index, JsonValue.class) == JsonValue.NULL;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        Iterator<JsonValue> it = this.unmodifieableBackingList.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            JsonValue jsonValue = it.next();
            if (JsonString.class.isInstance(jsonValue)) {
                builder.append(jsonValue.toString());
            } else {
                builder.append(jsonValue != JsonValue.NULL ? jsonValue.toString() : JsonChars.NULL);
            }
            if (!(hasNext = it.hasNext())) continue;
            builder.append(",");
        }
        return builder.append(']').toString();
    }

    @Override
    public boolean equals(Object obj) {
        return JsonArrayImpl.class.isInstance(obj) && this.unmodifieableBackingList.equals(((JsonArrayImpl)JsonArrayImpl.class.cast((Object)obj)).unmodifieableBackingList);
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.unmodifieableBackingList.hashCode());
        }
        return h;
    }

    @Override
    public JsonValue get(int index) {
        return this.unmodifieableBackingList.get(index);
    }

    @Override
    public int size() {
        return this.unmodifieableBackingList.size();
    }
}

