/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerImpl;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.junit.Assert;
import org.junit.Test;

public class CriticalMeasureTest {
    @Test
    public void testCriticalMeasure() throws Exception {
        CriticalMeasure measure = new CriticalMeasure(null, 1);
        long time = System.nanoTime();
        measure.timeEnter = time - TimeUnit.SECONDS.toNanos(5L);
        Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
    }

    @Test
    public void testCriticalMeasureTakingLongButSucceeding() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        CriticalMeasure measure = new CriticalMeasure((CriticalComponent)component, 1);
        long time = System.nanoTime();
        measure.enterCritical();
        measure.timeEnter = time - TimeUnit.MINUTES.toNanos(30L);
        measure.leaveCritical();
        Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
    }

    @Test
    public void testCriticalFailure() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        CriticalMeasure measure = new CriticalMeasure((CriticalComponent)component, 1);
        long time = System.nanoTime();
        CriticalCloseable closeable = measure.measure();
        measure.timeEnter = time - TimeUnit.MINUTES.toNanos(5L);
        Assert.assertTrue((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
        Assert.assertTrue((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), true));
        Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.SECONDS.toNanos(30L), false));
        closeable.close();
    }

    @Test
    public void testWithCloseable() throws Exception {
        CriticalAnalyzerImpl analyzer = new CriticalAnalyzerImpl();
        CriticalComponentImpl component = new CriticalComponentImpl((CriticalAnalyzer)analyzer, 5);
        CriticalMeasure measure = new CriticalMeasure((CriticalComponent)component, 1);
        long time = System.nanoTime();
        try (CriticalCloseable theMeasure = component.measureCritical(0);){
            LockSupport.parkNanos(1000L);
            Assert.assertTrue((boolean)component.checkExpiration(100L, false));
        }
        Assert.assertFalse((boolean)component.checkExpiration(100L, false));
    }
}

