/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ByteUtilTest {
    private static Logger log = Logger.getLogger(ByteUtilTest.class);

    @Test
    public void testBytesToString() {
        byte[] byteArray = new byte[]{0, 1, 2, 3};
        this.testEquals("0001 0203", ByteUtil.bytesToHex((byte[])byteArray, (int)2));
        this.testEquals("00 01 02 03", ByteUtil.bytesToHex((byte[])byteArray, (int)1));
        this.testEquals("000102 03", ByteUtil.bytesToHex((byte[])byteArray, (int)3));
    }

    @Test
    public void testNonASCII() {
        Assert.assertEquals((Object)"aA", (Object)ByteUtil.toSimpleString((byte[])new byte[]{97, 0, 65, 0}));
        Assert.assertEquals((Object)"@@@@@", (Object)ByteUtil.toSimpleString((byte[])new byte[]{0, 97, 0, 65}));
        log.debug((Object)ByteUtil.toSimpleString((byte[])new byte[]{0, 97, 0, 65}));
    }

    @Test
    public void testMaxString() {
        byte[] byteArray = new byte[20480];
        log.debug((Object)ByteUtil.maxString((String)ByteUtil.bytesToHex((byte[])byteArray, (int)2), (int)150));
    }

    void testEquals(String string1, String string2) {
        if (!string1.equals(string2)) {
            Assert.fail((String)("String are not the same:=" + string1 + "!=" + string2));
        }
    }

    @Test
    public void testTextBytesToLongBytes() {
        long[] factor = new long[]{1L, 5L, 10L};
        String[] type = new String[]{"", "b", "k", "m", "g"};
        long[] size = new long[]{1L, 1L, 1024L, 0x100000L, 0x40000000L};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < type.length; ++j) {
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j])));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j])));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j].toUpperCase())));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j].toUpperCase())));
                if (j < 2) continue;
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j] + "b")));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j] + "b")));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + type[j].toUpperCase() + "B")));
                Assert.assertEquals((long)(factor[i] * size[j]), (long)ByteUtil.convertTextBytes((String)(factor[i] + " " + type[j].toUpperCase() + "B")));
            }
        }
    }

    @Test
    public void testUnsafeUnalignedByteArrayHashCode() {
        Assume.assumeTrue((boolean)PlatformDependent.hasUnsafe());
        Assume.assumeTrue((boolean)PlatformDependent.isUnaligned());
        LinkedHashMap<byte[], Integer> map = new LinkedHashMap<byte[], Integer>();
        map.put(new byte[0], 1);
        map.put(new byte[]{1}, 32);
        map.put(new byte[]{2}, 33);
        map.put(new byte[]{0, 1}, 962);
        map.put(new byte[]{1, 2}, 994);
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            map.put(new byte[]{0, 1, 2, 3, 4, 5}, 63504931);
            map.put(new byte[]{6, 7, 8, 9, 0, 1}, -1603953111);
            map.put(new byte[]{-1, -1, -1, -31}, 1);
        } else {
            map.put(new byte[]{0, 1, 2, 3, 4, 5}, 1250309600);
            map.put(new byte[]{6, 7, 8, 9, 0, 1}, -417148442);
            map.put(new byte[]{-1, -1, -1, -31}, -503316450);
        }
        for (Map.Entry e : map.entrySet()) {
            Assert.assertEquals((String)("input = " + Arrays.toString((byte[])e.getKey())), (long)((Integer)e.getValue()).intValue(), (long)ByteUtil.hashCode((byte[])((byte[])e.getKey())));
        }
    }

    @Test
    public void testNoUnsafeAlignedByteArrayHashCode() {
        Assume.assumeFalse((boolean)PlatformDependent.hasUnsafe());
        Assume.assumeFalse((boolean)PlatformDependent.isUnaligned());
        ArrayList<byte[]> inputs = new ArrayList<byte[]>();
        inputs.add(new byte[0]);
        inputs.add(new byte[]{1});
        inputs.add(new byte[]{2});
        inputs.add(new byte[]{0, 1});
        inputs.add(new byte[]{1, 2});
        inputs.add(new byte[]{0, 1, 2, 3, 4, 5});
        inputs.add(new byte[]{6, 7, 8, 9, 0, 1});
        inputs.add(new byte[]{-1, -1, -1, -31});
        inputs.forEach(input -> Assert.assertEquals((String)("input = " + Arrays.toString(input)), (long)Arrays.hashCode(input), (long)ByteUtil.hashCode((byte[])input)));
    }

    @Test
    public void testTextBytesToLongBytesNegative() {
        try {
            ByteUtil.convertTextBytes((String)"x");
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    private static byte[] duplicateRemaining(ByteBuffer buffer, int offset, int bytes) {
        int end = offset + bytes;
        int expectedRemaining = buffer.capacity() - end;
        if (expectedRemaining <= 0) {
            return null;
        }
        byte[] remaining = new byte[expectedRemaining];
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.clear().position(end);
        duplicate.get(remaining, 0, expectedRemaining);
        return remaining;
    }

    private static byte[] duplicateBefore(ByteBuffer buffer, int offset) {
        if (offset <= 0) {
            return null;
        }
        int size = Math.min(buffer.capacity(), offset);
        byte[] remaining = new byte[size];
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.clear();
        duplicate.get(remaining, 0, size);
        return remaining;
    }

    private static void shouldZeroesByteBuffer(ByteBuffer buffer, int offset, int bytes) {
        byte[] originalBefore = ByteUtilTest.duplicateBefore(buffer, offset);
        byte[] originalRemaining = ByteUtilTest.duplicateRemaining(buffer, offset, bytes);
        int position = buffer.position();
        int limit = buffer.limit();
        ByteUtil.zeros((ByteBuffer)buffer, (int)offset, (int)bytes);
        Assert.assertEquals((long)position, (long)buffer.position());
        Assert.assertEquals((long)limit, (long)buffer.limit());
        byte[] zeros = new byte[bytes];
        byte[] content = new byte[bytes];
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.clear().position(offset);
        duplicate.get(content, 0, bytes);
        Assert.assertArrayEquals((byte[])zeros, (byte[])content);
        if (originalRemaining != null) {
            byte[] remaining = new byte[duplicate.remaining()];
            duplicate.get(remaining);
            Assert.assertArrayEquals((byte[])originalRemaining, (byte[])remaining);
        }
        if (originalBefore != null) {
            byte[] before = new byte[offset];
            duplicate.position(0);
            duplicate.get(before);
            Assert.assertArrayEquals((byte[])originalBefore, (byte[])before);
        }
    }

    private ByteBuffer fill(ByteBuffer buffer, int offset, int length, byte value) {
        for (int i = 0; i < length; ++i) {
            buffer.put(offset + i, value);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldZeroesDirectByteBuffer() {
        boolean one = true;
        int capacity = 64;
        int bytes = 32;
        boolean offset = true;
        ByteBuffer buffer = ByteBuffer.allocateDirect(64);
        try {
            this.fill(buffer, 0, 64, (byte)1);
            ByteUtilTest.shouldZeroesByteBuffer(buffer, 1, 32);
        }
        finally {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldZeroesLimitedDirectByteBuffer() {
        boolean one = true;
        int capacity = 64;
        int bytes = 32;
        boolean offset = true;
        ByteBuffer buffer = ByteBuffer.allocateDirect(64);
        try {
            this.fill(buffer, 0, 64, (byte)1);
            buffer.limit(0);
            ByteUtilTest.shouldZeroesByteBuffer(buffer, 1, 32);
        }
        finally {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
            }
        }
    }

    @Test
    public void shouldZeroesHeapByteBuffer() {
        boolean one = true;
        int capacity = 64;
        int bytes = 32;
        boolean offset = true;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        ByteUtilTest.shouldZeroesByteBuffer(buffer, 1, 32);
    }

    @Test
    public void shouldZeroesLimitedHeapByteBuffer() {
        boolean one = true;
        int capacity = 64;
        int bytes = 32;
        boolean offset = true;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        buffer.limit(0);
        ByteUtilTest.shouldZeroesByteBuffer(buffer, 1, 32);
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void shouldFailWithReadOnlyHeapByteBuffer() {
        boolean one = true;
        int capacity = 64;
        int bytes = 32;
        boolean offset = true;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        buffer = buffer.asReadOnlyBuffer();
        ByteUtilTest.shouldZeroesByteBuffer(buffer, 1, 32);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailIfOffsetIsGreaterOrEqualHeapByteBufferCapacity() {
        boolean one = true;
        int capacity = 64;
        boolean bytes = false;
        int offset = 64;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        try {
            ByteUtilTest.shouldZeroesByteBuffer(buffer, 64, 0);
        }
        catch (IndexOutOfBoundsException expectedEx) {
            byte[] originalContent = ByteUtilTest.duplicateRemaining(buffer, 0, 0);
            byte[] expectedContent = new byte[64];
            Arrays.fill(expectedContent, (byte)1);
            Assert.assertArrayEquals((byte[])expectedContent, (byte[])originalContent);
            throw expectedEx;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfOffsetIsNegative() {
        boolean one = true;
        int capacity = 64;
        boolean bytes = true;
        int offset = -1;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        try {
            ByteUtilTest.shouldZeroesByteBuffer(buffer, -1, 1);
        }
        catch (IndexOutOfBoundsException expectedEx) {
            byte[] originalContent = ByteUtilTest.duplicateRemaining(buffer, 0, 0);
            byte[] expectedContent = new byte[64];
            Arrays.fill(expectedContent, (byte)1);
            Assert.assertArrayEquals((byte[])expectedContent, (byte[])originalContent);
            throw expectedEx;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBytesIsNegative() {
        boolean one = true;
        int capacity = 64;
        int bytes = -1;
        boolean offset = false;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        try {
            ByteUtilTest.shouldZeroesByteBuffer(buffer, 0, -1);
        }
        catch (IndexOutOfBoundsException expectedEx) {
            byte[] originalContent = ByteUtilTest.duplicateRemaining(buffer, 0, 0);
            byte[] expectedContent = new byte[64];
            Arrays.fill(expectedContent, (byte)1);
            Assert.assertArrayEquals((byte[])expectedContent, (byte[])originalContent);
            throw expectedEx;
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailIfExceedingHeapByteBufferCapacity() {
        boolean one = true;
        int capacity = 64;
        int bytes = 65;
        boolean offset = true;
        ByteBuffer buffer = ByteBuffer.allocate(64);
        this.fill(buffer, 0, 64, (byte)1);
        try {
            ByteUtilTest.shouldZeroesByteBuffer(buffer, 1, 65);
        }
        catch (IndexOutOfBoundsException expectedEx) {
            byte[] originalContent = ByteUtilTest.duplicateRemaining(buffer, 0, 0);
            byte[] expectedContent = new byte[64];
            Arrays.fill(expectedContent, (byte)1);
            Assert.assertArrayEquals((byte[])expectedContent, (byte[])originalContent);
            throw expectedEx;
        }
    }

    @Test
    public void testIntToBytes() {
        this.internalIntToBytesTest(RandomUtil.randomInt(), null);
        this.internalIntToBytesTest(0, new byte[]{0, 0, 0, 0});
        this.internalIntToBytesTest(-1, new byte[]{-1, -1, -1, -1});
        this.internalIntToBytesTest(Integer.MIN_VALUE, new byte[]{-128, 0, 0, 0});
        this.internalIntToBytesTest(Integer.MAX_VALUE, new byte[]{127, -1, -1, -1});
    }

    private void internalIntToBytesTest(int intValue, byte[] manualExpect) {
        byte[] expected = ByteBuffer.allocate(4).putInt(intValue).array();
        byte[] actual = ByteUtil.intToBytes((int)intValue);
        if (manualExpect != null) {
            Assert.assertEquals((long)4L, (long)manualExpect.length);
            Assert.assertArrayEquals((byte[])manualExpect, (byte[])actual);
        }
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        Assert.assertEquals((long)intValue, (long)ByteUtil.bytesToInt((byte[])expected));
        Assert.assertEquals((long)intValue, (long)ByteUtil.bytesToInt((byte[])actual));
    }

    @Test
    public void testLongToBytes() {
        this.internalLongToBytesTest(RandomUtil.randomLong(), null);
        this.internalLongToBytesTest(0L, new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        this.internalLongToBytesTest(-1L, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        this.internalLongToBytesTest(Long.MIN_VALUE, new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
        this.internalLongToBytesTest(Long.MAX_VALUE, new byte[]{127, -1, -1, -1, -1, -1, -1, -1});
    }

    private void internalLongToBytesTest(long longValue, byte[] manualExpected) {
        byte[] expected = ByteBuffer.allocate(8).putLong(longValue).array();
        byte[] actual = ByteUtil.longToBytes((long)longValue);
        if (manualExpected != null) {
            Assert.assertEquals((long)8L, (long)manualExpected.length);
            Assert.assertArrayEquals((byte[])manualExpected, (byte[])actual);
        }
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        Assert.assertEquals((long)longValue, (long)ByteUtil.bytesToLong((byte[])expected));
        Assert.assertEquals((long)longValue, (long)ByteUtil.bytesToLong((byte[])actual));
    }

    @Test
    public void testDoubleLongToBytes() {
        long randomLong1 = RandomUtil.randomLong();
        long randomLong2 = RandomUtil.randomLong();
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(randomLong1);
        buffer.putLong(randomLong2);
        byte[] assertContent = buffer.array();
        byte[] convertedContent = ByteUtil.doubleLongToBytes((long)randomLong1, (long)randomLong2);
        Assert.assertArrayEquals((byte[])assertContent, (byte[])convertedContent);
    }
}

