/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonBuilderFactoryImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonReaderFactoryImpl;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonWriterFactoryImpl;

public class JsonProviderImpl
extends JsonProvider
implements Serializable {
    private static final JsonProvider DELEGATE = new JsonProviderDelegate();

    public JsonParser createParser(Reader reader) {
        return DELEGATE.createParser(reader);
    }

    public JsonParser createParser(InputStream inputStream) {
        return DELEGATE.createParser(inputStream);
    }

    public JsonParserFactory createParserFactory(Map<String, ?> stringMap) {
        return DELEGATE.createParserFactory(stringMap);
    }

    public JsonGenerator createGenerator(Writer writer) {
        return DELEGATE.createGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        return DELEGATE.createGenerator(outputStream);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> stringMap) {
        return DELEGATE.createGeneratorFactory(stringMap);
    }

    public JsonReader createReader(Reader reader) {
        return DELEGATE.createReader(reader);
    }

    public JsonReader createReader(InputStream inputStream) {
        return DELEGATE.createReader(inputStream);
    }

    public JsonWriter createWriter(Writer writer) {
        return DELEGATE.createWriter(writer);
    }

    public JsonWriter createWriter(OutputStream outputStream) {
        return DELEGATE.createWriter(outputStream);
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> stringMap) {
        return DELEGATE.createWriterFactory(stringMap);
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createReaderFactory(stringMap);
    }

    public JsonObjectBuilder createObjectBuilder() {
        return DELEGATE.createObjectBuilder();
    }

    public JsonArrayBuilder createArrayBuilder() {
        return DELEGATE.createArrayBuilder();
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createBuilderFactory(stringMap);
    }

    static class JsonProviderDelegate
    extends JsonProvider {
        private final JsonReaderFactory readerFactory = new JsonReaderFactoryImpl(null);
        private final JsonParserFactory parserFactory = new JsonParserFactoryImpl(null);
        private final JsonGeneratorFactory generatorFactory = new JsonGeneratorFactoryImpl(null);
        private final JsonWriterFactory writerFactory = new JsonWriterFactoryImpl(null);
        private final JsonBuilderFactory builderFactory = new JsonBuilderFactoryImpl(null);

        JsonProviderDelegate() {
        }

        public JsonParser createParser(InputStream in) {
            return this.parserFactory.createParser(in);
        }

        public JsonParser createParser(Reader reader) {
            return this.parserFactory.createParser(reader);
        }

        public JsonReader createReader(InputStream in) {
            return this.readerFactory.createReader(in);
        }

        public JsonReader createReader(Reader reader) {
            return this.readerFactory.createReader(reader);
        }

        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.parserFactory : new JsonParserFactoryImpl(config);
        }

        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.readerFactory : new JsonReaderFactoryImpl(config);
        }

        public JsonGenerator createGenerator(Writer writer) {
            return this.generatorFactory.createGenerator(writer);
        }

        public JsonGenerator createGenerator(OutputStream out) {
            return this.generatorFactory.createGenerator(out);
        }

        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.generatorFactory : new JsonGeneratorFactoryImpl(config);
        }

        public JsonWriter createWriter(Writer writer) {
            return this.writerFactory.createWriter(writer);
        }

        public JsonWriter createWriter(OutputStream out) {
            return this.writerFactory.createWriter(out);
        }

        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.writerFactory : new JsonWriterFactoryImpl(config);
        }

        public JsonObjectBuilder createObjectBuilder() {
            return this.builderFactory.createObjectBuilder();
        }

        public JsonArrayBuilder createArrayBuilder() {
            return this.builderFactory.createArrayBuilder();
        }

        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.builderFactory : new JsonBuilderFactoryImpl(config);
        }
    }
}

