/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonNumberImpl
implements JsonNumber {
    private final BigDecimal value;
    private Integer hashCode = null;

    JsonNumberImpl(BigDecimal decimal) {
        if (decimal == null) {
            throw new NullPointerException("decimal must not be null");
        }
        this.value = decimal;
    }

    public boolean isIntegral() {
        return this.value.scale() == 0;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public int intValueExact() {
        return this.value.intValueExact();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public long longValueExact() {
        return this.value.longValueExact();
    }

    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return this.value.toBigIntegerExact();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.value.hashCode());
        }
        return h;
    }

    public boolean equals(Object obj) {
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue().equals(this.value);
    }
}

