/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.io.Serializable;
import javax.json.stream.JsonLocation;

final class JsonLocationImpl
implements JsonLocation,
Serializable {
    public static final JsonLocation UNKNOWN_LOCATION = new JsonLocationImpl(-1L, -1L, -1L);
    private final long lineNumber;
    private final long columnNumber;
    private final long streamOffset;

    JsonLocationImpl(long lineNumber, long columnNumber, long streamOffset) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.streamOffset = streamOffset;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public long getColumnNumber() {
        return this.columnNumber;
    }

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonLocationImpl that = (JsonLocationImpl)JsonLocationImpl.class.cast(o);
        return this.columnNumber == that.columnNumber && this.lineNumber == that.lineNumber && this.streamOffset == that.streamOffset;
    }

    public int hashCode() {
        int result = (int)(this.lineNumber ^ this.lineNumber >>> 32);
        result = 31 * result + (int)(this.columnNumber ^ this.columnNumber >>> 32);
        result = 31 * result + (int)(this.streamOffset ^ this.streamOffset >>> 32);
        return result;
    }

    public String toString() {
        return "[lineNumber=" + this.lineNumber + ", columnNumber=" + this.columnNumber + ", streamOffset=" + this.streamOffset + "]";
    }
}

