/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ConnectionAbstract
extends InputAbstract {
    private static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    @Option(name={"--url"}, description="URL towards the broker. (default: Read from current broker.xml or tcp://localhost:61616 if the default cannot be parsed)")
    protected String brokerURL = "tcp://localhost:61616";
    @Option(name={"--user"}, description="User used to connect")
    protected String user;
    @Option(name={"--password"}, description="Password used to connect")
    protected String password;
    @Option(name={"--clientID"}, description="ClientID to be associated with connection")
    String clientID;
    @Option(name={"--protocol"}, description="Protocol used. Valid values are amqp or core. Default=core.")
    String protocol = "core";

    public String getUser() {
        return this.user;
    }

    public ConnectionAbstract setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionAbstract setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public ConnectionAbstract setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        String brokerURLInstance;
        super.execute(context);
        if (this.brokerURL == DEFAULT_BROKER_URL && (brokerURLInstance = this.getBrokerURLInstance()) != null) {
            this.brokerURL = brokerURLInstance;
        }
        System.out.println("Connection brokerURL = " + this.brokerURL);
        return null;
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        if (this.protocol.equals("core")) {
            return this.createCoreConnectionFactory();
        }
        if (this.protocol.equals("amqp")) {
            return this.createAMQPConnectionFactory();
        }
        throw new IllegalStateException("protocol " + this.protocol + " not supported");
    }

    private ConnectionFactory createAMQPConnectionFactory() {
        if (this.brokerURL.startsWith("tcp://")) {
            this.brokerURL = "amqp" + this.brokerURL.substring(3);
        }
        JmsConnectionFactory cf = new JmsConnectionFactory(this.user, this.password, this.brokerURL);
        if (this.clientID != null) {
            cf.setClientID(this.clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.userPassword();
            cf = new JmsConnectionFactory(this.user, this.password, this.brokerURL);
            if (this.clientID != null) {
                cf.setClientID(this.clientID);
            }
            return cf;
        }
        catch (JMSException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.brokerURL = this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", this.brokerURL);
            this.userPassword();
            cf = new JmsConnectionFactory(this.user, this.password, this.brokerURL);
            if (this.clientID != null) {
                cf.setClientID(this.clientID);
            }
            return cf;
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory() {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.brokerURL, this.user, this.password);
        if (this.clientID != null) {
            System.out.println("Consumer:: clientID = " + this.clientID);
            cf.setClientID(this.clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            if (this.context != null) {
                this.context.err.println("Connection failed::" + e.getMessage());
            }
            this.userPassword();
            cf = new ActiveMQConnectionFactory(this.brokerURL, this.user, this.password);
            if (this.clientID != null) {
                cf.setClientID(this.clientID);
            }
            return cf;
        }
        catch (JMSException e) {
            if (this.context != null) {
                this.context.err.println("Connection failed::" + e.getMessage());
            }
            this.brokerURL = this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", this.brokerURL);
            this.userPassword();
            cf = new ActiveMQConnectionFactory(this.brokerURL, this.user, this.password);
            if (this.clientID != null) {
                cf.setClientID(this.clientID);
            }
            return cf;
        }
    }

    private void userPassword() {
        if (this.user == null) {
            this.user = this.input("--user", "Type the username for a retry", null);
        }
        if (this.password == null) {
            this.password = this.inputPassword("--password", "Type the password for a retry", null);
        }
    }
}

