/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.tests;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class NioClientTest {
    protected volatile boolean running = true;
    protected final AtomicLong total_bytes_sent = new AtomicLong(0L);
    protected final AtomicLong total_msgs = new AtomicLong(0L);
    protected Sender[] senders;

    protected static ByteBuffer create(int size, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    protected void start(InetAddress host, boolean direct, int num_threads) throws Exception {
        boolean looping = true;
        while (looping) {
            int c = Util.keyPress("[1] send [x] exit");
            switch (c) {
                case 49: {
                    this.sendMessages(host, direct, num_threads);
                    break;
                }
                case 120: {
                    looping = false;
                }
            }
        }
    }

    protected void sendMessages(InetAddress host, boolean direct, int num_threads) throws Exception {
        this.total_msgs.set(0L);
        this.total_bytes_sent.set(0L);
        this.senders = new Sender[num_threads];
        CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < this.senders.length; ++i) {
            this.senders[i] = new Sender(host, direct, latch);
        }
        for (Sender sender : this.senders) {
            sender.start();
        }
        latch.countDown();
        for (Sender sender : this.senders) {
            sender.join();
        }
    }

    public static void main(String[] args) throws Exception {
        String host = "localhost";
        boolean direct = false;
        int num_threads = 5;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-direct")) {
                direct = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-num_threads")) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("NioClientTest [-host host] [-direct true|false] [-num_threads num]");
            return;
        }
        new NioClientTest().start(InetAddress.getByName(host), direct, num_threads);
    }

    protected class Sender
    extends Thread {
        protected SocketChannel ch;
        protected final CountDownLatch latch;
        protected final InetAddress host;
        protected final boolean direct;
        protected final ByteBuffer buf;

        public Sender(InetAddress host, boolean direct, CountDownLatch latch) {
            this.latch = latch;
            this.host = host;
            this.direct = direct;
            this.buf = NioClientTest.create(1000, direct);
        }

        @Override
        public void run() {
            try {
                this.ch = SocketChannel.open();
                this.ch.configureBlocking(true);
                this.ch.connect(new InetSocketAddress(this.host, 7500));
                this.latch.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (NioClientTest.this.total_bytes_sent.addAndGet(1000L) <= 10000000L) {
                this.buf.rewind();
                try {
                    this.ch.write(this.buf);
                    NioClientTest.this.total_msgs.incrementAndGet();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Util.close((Closeable)this.ch);
        }
    }
}

