/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.ProtocolHandler;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.osgi.service.component.annotations.Component;

@Component(service={ProtocolManagerFactory.class})
public class MQTTProtocolManagerFactory
extends AbstractProtocolManagerFactory<MQTTInterceptor> {
    public static final String MQTT_PROTOCOL_NAME = "MQTT";
    private static final String MODULE_NAME = "artemis-mqtt-protocol";
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"MQTT"};

    public ProtocolManager createProtocolManager(ActiveMQServer server, Map<String, Object> parameters, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) throws Exception {
        BeanSupport.stripPasswords(parameters);
        return (ProtocolManager)BeanSupport.setData((Object)((Object)new MQTTProtocolManager(server, incomingInterceptors, outgoingInterceptors)), parameters);
    }

    public List<MQTTInterceptor> filterInterceptors(List<BaseInterceptor> interceptors) {
        return this.internalFilterInterceptors(MQTTInterceptor.class, interceptors);
    }

    public String[] getProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public void loadProtocolServices(ActiveMQServer server, List<ActiveMQComponent> services) {
        services.add((ActiveMQComponent)new MQTTPeriodicTasks(server, server.getScheduledPool()));
    }

    public class MQTTPeriodicTasks
    extends ActiveMQScheduledComponent {
        final ActiveMQServer server;

        public MQTTPeriodicTasks(ActiveMQServer server, ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService, null, 5L, TimeUnit.SECONDS, false);
            this.server = server;
        }

        public void run() {
            this.server.getRemotingService().getAcceptors().forEach((key, acceptor) -> {
                ProtocolHandler protocolHandler = acceptor.getProtocolHandler();
                if (protocolHandler != null) {
                    protocolHandler.getProtocolMap().values().forEach(m -> {
                        if (m instanceof MQTTProtocolManager) {
                            ((MQTTProtocolManager)((Object)((Object)m))).scanSessions();
                        }
                    });
                }
            });
        }
    }
}

