/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.artemis.utils.collections.MultiIterator;
import org.junit.Assert;
import org.junit.Test;

public class MultiIteratorTest {
    @Test
    public void testSingleIterator() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            arrayList.add(i);
        }
        MultiIterator iterator = new MultiIterator(new Iterator[]{arrayList.iterator()});
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMutlipleIterators() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            arrayList.add(i);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 1000; i < 2000; ++i) {
            arrayList2.add(i);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 2000; i < 3000; ++i) {
            arrayList3.add(i);
        }
        MultiIterator iterator = new MultiIterator(new Iterator[]{arrayList.iterator(), arrayList2.iterator(), arrayList3.iterator()});
        for (int i = 0; i < 3000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

