/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypedPropertiesTest {
    private TypedProperties props;
    private SimpleString key;
    private static final SimpleString PROP_NAME = SimpleString.toSimpleString((String)"TEST_PROP");

    private static void assertEqualsTypeProperties(TypedProperties expected, TypedProperties actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((long)expected.getEncodeSize(), (long)actual.getEncodeSize());
        Assert.assertEquals((Object)expected.getPropertyNames(), (Object)actual.getPropertyNames());
        for (SimpleString key : actual.getPropertyNames()) {
            Object expectedValue = expected.getProperty(key);
            Object actualValue = actual.getProperty(key);
            if (expectedValue instanceof byte[] && actualValue instanceof byte[]) {
                byte[] expectedBytes = (byte[])expectedValue;
                byte[] actualBytes = (byte[])actualValue;
                Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
                continue;
            }
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
    }

    @Test
    public void testCopyContructor() throws Exception {
        this.props.putSimpleStringProperty(this.key, RandomUtil.randomSimpleString());
        TypedProperties copy = new TypedProperties(this.props);
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)copy.getEncodeSize());
        Assert.assertEquals((Object)this.props.getPropertyNames(), (Object)copy.getPropertyNames());
        Assert.assertTrue((boolean)copy.containsProperty(this.key));
        Assert.assertEquals((Object)this.props.getProperty(this.key), (Object)copy.getProperty(this.key));
    }

    @Test
    public void testRemove() throws Exception {
        this.props.putSimpleStringProperty(this.key, RandomUtil.randomSimpleString());
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNotNull((Object)this.props.getProperty(this.key));
        this.props.removeProperty(this.key);
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testClear() throws Exception {
        this.props.putSimpleStringProperty(this.key, RandomUtil.randomSimpleString());
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNotNull((Object)this.props.getProperty(this.key));
        Assert.assertThat((Object)this.props.getEncodeSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.props.clear();
        Assert.assertEquals((long)1L, (long)this.props.getEncodeSize());
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testKey() throws Exception {
        this.props.putBooleanProperty(this.key, true);
        boolean bool = (Boolean)this.props.getProperty(this.key);
        Assert.assertEquals((Object)true, (Object)bool);
        this.props.putCharProperty(this.key, 'a');
        char c = ((Character)this.props.getProperty(this.key)).charValue();
        Assert.assertEquals((long)97L, (long)c);
    }

    @Test
    public void testGetPropertyOnEmptyProperties() throws Exception {
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testRemovePropertyOnEmptyProperties() throws Exception {
        Assert.assertFalse((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.removeProperty(this.key));
    }

    @Test
    public void testNullProperty() throws Exception {
        this.props.putSimpleStringProperty(this.key, null);
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getProperty(this.key));
    }

    @Test
    public void testBytesPropertyWithNull() throws Exception {
        this.props.putBytesProperty(this.key, null);
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        byte[] bb = (byte[])this.props.getProperty(this.key);
        Assert.assertNull((Object)bb);
    }

    @Test
    public void testTypedProperties() throws Exception {
        SimpleString longKey = RandomUtil.randomSimpleString();
        long longValue = RandomUtil.randomLong();
        SimpleString simpleStringKey = RandomUtil.randomSimpleString();
        SimpleString simpleStringValue = RandomUtil.randomSimpleString();
        TypedProperties otherProps = new TypedProperties();
        otherProps.putLongProperty(longKey, longValue);
        otherProps.putSimpleStringProperty(simpleStringKey, simpleStringValue);
        this.props.putTypedProperties(otherProps);
        long ll = this.props.getLongProperty(longKey);
        Assert.assertEquals((long)longValue, (long)ll);
        SimpleString ss = this.props.getSimpleStringProperty(simpleStringKey);
        Assert.assertEquals((Object)simpleStringValue, (Object)ss);
    }

    @Test
    public void testEmptyTypedProperties() throws Exception {
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
        this.props.putTypedProperties(new TypedProperties());
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
    }

    @Test
    public void testNullTypedProperties() throws Exception {
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
        this.props.putTypedProperties(null);
        Assert.assertEquals((long)0L, (long)this.props.getPropertyNames().size());
    }

    @Test
    public void testEncodeDecode() throws Exception {
        this.props.putByteProperty(RandomUtil.randomSimpleString(), RandomUtil.randomByte());
        this.props.putBytesProperty(RandomUtil.randomSimpleString(), RandomUtil.randomBytes());
        this.props.putBytesProperty(RandomUtil.randomSimpleString(), null);
        this.props.putBooleanProperty(RandomUtil.randomSimpleString(), RandomUtil.randomBoolean());
        this.props.putShortProperty(RandomUtil.randomSimpleString(), RandomUtil.randomShort());
        this.props.putIntProperty(RandomUtil.randomSimpleString(), RandomUtil.randomInt());
        this.props.putLongProperty(RandomUtil.randomSimpleString(), RandomUtil.randomLong());
        this.props.putFloatProperty(RandomUtil.randomSimpleString(), RandomUtil.randomFloat());
        this.props.putDoubleProperty(RandomUtil.randomSimpleString(), RandomUtil.randomDouble());
        this.props.putCharProperty(RandomUtil.randomSimpleString(), RandomUtil.randomChar());
        this.props.putSimpleStringProperty(RandomUtil.randomSimpleString(), RandomUtil.randomSimpleString());
        this.props.putSimpleStringProperty(RandomUtil.randomSimpleString(), null);
        SimpleString keyToRemove = RandomUtil.randomSimpleString();
        this.props.putSimpleStringProperty(keyToRemove, RandomUtil.randomSimpleString());
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        this.props.encode(buffer.byteBuf());
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)buffer.writerIndex());
        TypedProperties decodedProps = new TypedProperties();
        decodedProps.decode(buffer.byteBuf());
        TypedPropertiesTest.assertEqualsTypeProperties(this.props, decodedProps);
        buffer.clear();
        this.props.removeProperty(keyToRemove);
        this.props.encode(buffer.byteBuf());
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)buffer.writerIndex());
    }

    @Test
    public void testEncodeDecodeEmpty() throws Exception {
        TypedProperties emptyProps = new TypedProperties();
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
        emptyProps.encode(buffer.byteBuf());
        Assert.assertEquals((long)this.props.getEncodeSize(), (long)buffer.writerIndex());
        TypedProperties decodedProps = new TypedProperties();
        decodedProps.decode(buffer.byteBuf());
        TypedPropertiesTest.assertEqualsTypeProperties(emptyProps, decodedProps);
    }

    @Test
    public void testCannotClearInternalPropertiesIfEmpty() {
        TypedProperties properties = new TypedProperties();
        Assert.assertFalse((boolean)properties.clearInternalProperties());
    }

    @Test
    public void testClearInternalPropertiesIfAny() {
        TypedProperties properties = new TypedProperties(arg_0 -> ((SimpleString)PROP_NAME).equals(arg_0));
        properties.putBooleanProperty(PROP_NAME, RandomUtil.randomBoolean());
        Assert.assertTrue((boolean)properties.clearInternalProperties());
        Assert.assertFalse((boolean)properties.containsProperty(PROP_NAME));
    }

    @Test
    public void testCannotClearInternalPropertiesTwiceIfAny() {
        TypedProperties properties = new TypedProperties(arg_0 -> ((SimpleString)PROP_NAME).equals(arg_0));
        properties.putBooleanProperty(PROP_NAME, RandomUtil.randomBoolean());
        Assert.assertTrue((boolean)properties.clearInternalProperties());
        Assert.assertFalse((boolean)properties.clearInternalProperties());
    }

    @Test
    public void testSearchPropertyIfNone() {
        TypedProperties props = new TypedProperties();
        ByteBuf buf = Unpooled.buffer((int)1, (int)1);
        props.encode(buf);
        buf.resetReaderIndex();
        Assert.assertFalse((String)"There is no property", (boolean)TypedProperties.searchProperty((SimpleString)SimpleString.toSimpleString((String)""), (ByteBuf)buf, (int)0));
    }

    @Test
    public void testSearchAllProperties() {
        TypedProperties props = new TypedProperties();
        props.putByteProperty(RandomUtil.randomSimpleString(), RandomUtil.randomByte());
        props.putBytesProperty(RandomUtil.randomSimpleString(), RandomUtil.randomBytes());
        props.putBytesProperty(RandomUtil.randomSimpleString(), null);
        props.putBooleanProperty(RandomUtil.randomSimpleString(), RandomUtil.randomBoolean());
        props.putShortProperty(RandomUtil.randomSimpleString(), RandomUtil.randomShort());
        props.putIntProperty(RandomUtil.randomSimpleString(), RandomUtil.randomInt());
        props.putLongProperty(RandomUtil.randomSimpleString(), RandomUtil.randomLong());
        props.putFloatProperty(RandomUtil.randomSimpleString(), RandomUtil.randomFloat());
        props.putDoubleProperty(RandomUtil.randomSimpleString(), RandomUtil.randomDouble());
        props.putCharProperty(RandomUtil.randomSimpleString(), RandomUtil.randomChar());
        props.putSimpleStringProperty(RandomUtil.randomSimpleString(), RandomUtil.randomSimpleString());
        props.putSimpleStringProperty(RandomUtil.randomSimpleString(), null);
        SimpleString value = RandomUtil.randomSimpleString();
        props.putSimpleStringProperty(RandomUtil.randomSimpleString(), value);
        ByteBuf buf = Unpooled.buffer();
        props.encode(buf);
        buf.resetReaderIndex();
        Assert.assertFalse((boolean)TypedProperties.searchProperty((SimpleString)value, (ByteBuf)buf, (int)0));
        props.forEachKey(key -> {
            Assert.assertTrue((boolean)TypedProperties.searchProperty((SimpleString)key, (ByteBuf)buf, (int)0));
            Assert.assertTrue((boolean)TypedProperties.searchProperty((SimpleString)SimpleString.toSimpleString((String)key.toString()), (ByteBuf)buf, (int)0));
            Assert.assertFalse((boolean)TypedProperties.searchProperty((SimpleString)key.concat(" "), (ByteBuf)buf, (int)0));
        });
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSearchPartiallyEncodedBuffer() {
        int expectedLength = 5;
        ByteBuf buf = Unpooled.buffer((int)5, (int)5);
        buf.writeByte(1);
        buf.writeInt(1);
        buf.resetReaderIndex();
        TypedProperties.searchProperty((SimpleString)SimpleString.toSimpleString((String)" "), (ByteBuf)buf, (int)0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSearchPartiallyEncodedString() {
        int expectedLength = 9;
        ByteBuf buf = Unpooled.buffer((int)9, (int)9);
        buf.writeByte(1);
        buf.writeInt(1);
        buf.writeInt(2);
        buf.resetReaderIndex();
        TypedProperties.searchProperty((SimpleString)SimpleString.toSimpleString((String)"a"), (ByteBuf)buf, (int)0);
    }

    @Test(expected=IllegalStateException.class)
    public void testSearchWithInvalidTypeBeforeEnd() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(1);
        buf.writeInt(2);
        buf.writeInt(2);
        buf.writeShort(3);
        buf.writeByte(-128);
        buf.resetReaderIndex();
        TypedProperties.searchProperty((SimpleString)SimpleString.toSimpleString((String)""), (ByteBuf)buf, (int)0);
    }

    @Test
    public void testSearchWithInvalidTypeEnd() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(1);
        buf.writeInt(1);
        buf.writeInt(2);
        buf.writeShort(3);
        buf.writeByte(-128);
        buf.resetReaderIndex();
        Assert.assertFalse((boolean)TypedProperties.searchProperty((SimpleString)SimpleString.toSimpleString((String)""), (ByteBuf)buf, (int)0));
    }

    @Before
    public void setUp() throws Exception {
        this.props = new TypedProperties();
        this.key = RandomUtil.randomSimpleString();
    }

    @Test
    public void testByteBufStringValuePool() {
        int capacity = 8;
        int chars = Integer.toString(8).length();
        TypedProperties.StringValue.ByteBufStringValuePool pool = new TypedProperties.StringValue.ByteBufStringValuePool(8, chars);
        int bytes = new SimpleString(Integer.toString(8)).sizeof();
        ByteBuf bb = Unpooled.buffer((int)bytes, (int)bytes);
        for (int i = 0; i < 8; ++i) {
            SimpleString s = new SimpleString(Integer.toString(i));
            bb.resetWriterIndex();
            SimpleString.writeSimpleString((ByteBuf)bb, (SimpleString)s);
            bb.resetReaderIndex();
            TypedProperties.StringValue expectedPooled = (TypedProperties.StringValue)pool.getOrCreate(bb);
            bb.resetReaderIndex();
            Assert.assertSame((Object)expectedPooled, (Object)pool.getOrCreate(bb));
            bb.resetReaderIndex();
        }
    }

    @Test
    public void testByteBufStringValuePoolTooLong() {
        SimpleString tooLong = new SimpleString("aa");
        ByteBuf bb = Unpooled.buffer((int)tooLong.sizeof(), (int)tooLong.sizeof());
        SimpleString.writeSimpleString((ByteBuf)bb, (SimpleString)tooLong);
        TypedProperties.StringValue.ByteBufStringValuePool pool = new TypedProperties.StringValue.ByteBufStringValuePool(1, tooLong.length() - 1);
        Assert.assertNotSame((Object)pool.getOrCreate(bb), (Object)pool.getOrCreate(bb.resetReaderIndex()));
    }

    @Test
    public void testCopyingWhileMessingUp() throws Exception {
        final TypedProperties properties = new TypedProperties();
        final AtomicBoolean running = new AtomicBoolean(true);
        final AtomicLong copies = new AtomicLong(0L);
        final AtomicBoolean error = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                while (running.get() && !error.get()) {
                    try {
                        copies.incrementAndGet();
                        TypedProperties typedProperties = new TypedProperties(properties);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        error.set(true);
                    }
                }
            }
        };
        t.start();
        for (int i = 0; !(error.get() || i >= 100 && copies.get() >= 50L); ++i) {
            properties.putIntProperty(SimpleString.toSimpleString((String)("key" + i)), i);
        }
        running.set(false);
        t.join();
        Assert.assertFalse((boolean)error.get());
    }
}

