/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.policies;

import java.util.List;
import org.apache.activemq.artemis.core.server.balancing.policies.AbstractPolicy;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.utils.RandomUtil;

public class RoundRobinPolicy
extends AbstractPolicy {
    public static final String NAME = "ROUND_ROBIN";
    private int pos = RandomUtil.randomInterval((int)0, (int)Integer.MAX_VALUE);

    public RoundRobinPolicy() {
        super(NAME);
    }

    protected RoundRobinPolicy(String name) {
        super(name);
    }

    @Override
    public Target selectTarget(List<Target> targets, String key) {
        if (targets.size() > 0) {
            this.pos %= targets.size();
            return targets.get(this.pos++);
        }
        return null;
    }
}

