/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.BasicOutputExpressionNode;
import org.apache.camel.model.DisabledAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@AsPredicate
@XmlRootElement(name="when")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WhenDefinition
extends BasicOutputExpressionNode
implements DisabledAwareDefinition {
    @XmlTransient
    private ProcessorDefinition<?> parent;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", description="Disables this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled late at runtime.")
    private String disabled;

    public WhenDefinition() {
    }

    public WhenDefinition(WhenDefinition source) {
        super(source);
        this.parent = source.parent;
        this.disabled = source.disabled;
    }

    public WhenDefinition(Predicate predicate) {
        super(predicate);
    }

    public WhenDefinition(Expression expression) {
        super(expression);
    }

    public WhenDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    @Override
    public ProcessorDefinition<?> getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition<?> parent) {
        this.parent = parent;
    }

    @Override
    public WhenDefinition copyDefinition() {
        return new WhenDefinition(this);
    }

    public String toString() {
        return "When[" + this.description() + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    public String getShortName() {
        return "when";
    }

    @Override
    public String getLabel() {
        return "when[" + this.description() + "]";
    }

    protected String description() {
        StringBuilder sb = new StringBuilder(256);
        if (this.getExpression() != null) {
            String language = this.getExpression().getLanguage();
            if (language != null) {
                sb.append(language).append("{");
            }
            sb.append(this.getExpression().getLabel());
            if (language != null) {
                sb.append("}");
            }
        }
        return sb.toString();
    }

    @Override
    public void setId(String id) {
        if (this.getOutputs().isEmpty()) {
            super.setId(id);
        } else {
            ProcessorDefinition<?> last = this.getOutputs().get(this.getOutputs().size() - 1);
            last.setId(id);
        }
    }

    @Override
    public String getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }
}

