/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util.jmx;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.util.jmx.JmxUtil;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.core.util.jmx.MBeanServers;

public class DefaultMBeanServerAccess
implements MBeanServerAccess,
NotificationListener {
    private long lastMBeanRegistrationChange;
    private final MBeanServers mbeanServers;

    public DefaultMBeanServerAccess() {
        this(null);
    }

    public DefaultMBeanServerAccess(Set<MBeanServerConnection> pServers) {
        this.mbeanServers = new MBeanServers(pServers, this);
        this.registerForMBeanNotifications(this.mbeanServers);
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        return this.mbeanServers.getMBeanServers();
    }

    protected MBeanServerConnection getJolokiaMBeanServer() {
        return this.mbeanServers.getJolokiaMBeanServer();
    }

    @Override
    public void each(ObjectName pObjectName, MBeanServerAccess.MBeanEachCallback pCallback) throws IOException, ReflectionException, MBeanException {
        try {
            HashSet<ObjectName> visited = new HashSet<ObjectName>();
            for (MBeanServerConnection server : this.getMBeanServers()) {
                for (ObjectName nameObject : server.queryNames(pObjectName, null)) {
                    if (visited.contains(nameObject)) continue;
                    pCallback.callback(server, nameObject);
                    visited.add(nameObject);
                }
            }
        }
        catch (InstanceNotFoundException exp) {
            throw new IllegalArgumentException("Cannot find MBean " + (String)(pObjectName != null ? "(MBean " + pObjectName + ")" : "") + ": " + exp, exp);
        }
    }

    public <T> T call(ObjectName pObjectName, MBeanServerAccess.MBeanAction<T> pMBeanAction, Object ... pExtraArgs) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        InstanceNotFoundException objNotFoundException = null;
        for (MBeanServerConnection server : this.getMBeanServers()) {
            try {
                return pMBeanAction.execute(server, pObjectName, pExtraArgs);
            }
            catch (InstanceNotFoundException exp) {
                objNotFoundException = exp;
            }
        }
        throw (InstanceNotFoundException)Objects.requireNonNull(objNotFoundException);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName pObjectName) throws IOException {
        LinkedHashSet<ObjectName> names = new LinkedHashSet<ObjectName>();
        for (MBeanServerConnection server : this.getMBeanServers()) {
            names.addAll(server.queryNames(pObjectName, null));
        }
        return names;
    }

    private void registerForMBeanNotifications(MBeanServers pServers) {
        Exception lastExp = null;
        StringBuilder errors = new StringBuilder();
        for (MBeanServerConnection server : pServers.getMBeanServers()) {
            try {
                JmxUtil.addMBeanRegistrationListener(server, this, null);
            }
            catch (IllegalStateException e) {
                lastExp = this.updateErrorMsg(errors, e);
            }
        }
        if (lastExp != null) {
            throw new IllegalStateException(errors.substring(0, errors.length() - 1), lastExp);
        }
    }

    public void unregisterFromMBeanNotifications() {
        Set<MBeanServerConnection> servers = this.getMBeanServers();
        Exception lastExp = null;
        StringBuilder errors = new StringBuilder();
        for (MBeanServerConnection server : servers) {
            try {
                JmxUtil.removeMBeanRegistrationListener(server, this);
            }
            catch (IllegalStateException e) {
                lastExp = this.updateErrorMsg(errors, e);
            }
        }
        if (lastExp != null) {
            throw new IllegalStateException(errors.substring(0, errors.length() - 1), lastExp);
        }
        this.mbeanServers.destroy();
    }

    @Override
    public void handleNotification(Notification pNotification, Object pHandback) {
        this.lastMBeanRegistrationChange = System.currentTimeMillis();
    }

    @Override
    public boolean hasMBeansListChangedSince(long pTimestamp) {
        return this.lastMBeanRegistrationChange / 1000L >= pTimestamp;
    }

    private Exception updateErrorMsg(StringBuilder pErrors, Exception exp) {
        pErrors.append(exp.getClass()).append(": ").append(exp.getMessage()).append("\n");
        return exp;
    }

    public String dumpMBeanServers() {
        return this.mbeanServers.dump();
    }
}

