/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.errorhandler;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.LoggingLevel;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.spi.Metadata;

public abstract class TransactionErrorHandlerDefinition
extends DefaultErrorHandlerDefinition {
    @XmlTransient
    private Object transactedPolicy;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.spi.TransactedPolicy")
    private String transactedPolicyRef;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.LoggingLevel", defaultValue="WARN", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String rollbackLoggingLevel;

    public TransactionErrorHandlerDefinition() {
    }

    public TransactionErrorHandlerDefinition(TransactionErrorHandlerDefinition source) {
        super(source);
        this.transactedPolicy = source.transactedPolicy;
        this.transactedPolicyRef = source.transactedPolicyRef;
        this.rollbackLoggingLevel = source.rollbackLoggingLevel;
    }

    @Override
    public boolean supportTransacted() {
        return true;
    }

    protected void cloneBuilder(TransactionErrorHandlerDefinition other) {
        other.setTransactedPolicyRef(this.getTransactedPolicyRef());
        other.setRollbackLoggingLevel(this.getRollbackLoggingLevel());
        super.cloneBuilder(other);
    }

    public Object getTransactedPolicy() {
        return this.transactedPolicy;
    }

    public void setTransactedPolicy(Object transactedPolicy) {
        this.transactedPolicy = transactedPolicy;
    }

    public String getTransactedPolicyRef() {
        return this.transactedPolicyRef;
    }

    public void setTransactedPolicyRef(String transactedPolicyRef) {
        this.transactedPolicyRef = transactedPolicyRef;
    }

    public String getRollbackLoggingLevel() {
        return this.rollbackLoggingLevel;
    }

    public void setRollbackLoggingLevel(String rollbackLoggingLevel) {
        this.rollbackLoggingLevel = rollbackLoggingLevel;
    }

    public TransactionErrorHandlerDefinition transactedPolicy(Object transactedPolicy) {
        this.setTransactedPolicy(transactedPolicy);
        return this;
    }

    public TransactionErrorHandlerDefinition transactedPolicyRef(String transactedPolicyRef) {
        this.setTransactedPolicyRef(transactedPolicyRef);
        return this;
    }

    public TransactionErrorHandlerDefinition rollbackLoggingLevel(String rollbackLoggingLevel) {
        this.setRollbackLoggingLevel(rollbackLoggingLevel);
        return this;
    }

    public TransactionErrorHandlerDefinition rollbackLoggingLevel(LoggingLevel rollbackLoggingLevel) {
        this.setRollbackLoggingLevel(rollbackLoggingLevel.name());
        return this;
    }
}

