/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.Traceable;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProcessor
extends AsyncProcessorSupport
implements Traceable,
EndpointAware,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SendProcessor.class);
    protected transient String traceLabelToString;
    protected final CamelContext camelContext;
    protected final ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected AsyncProducer producer;
    protected HeadersMapFactory headersMapFactory;
    protected final Endpoint destination;
    protected String variableSend;
    protected String variableReceive;
    protected ExchangePattern destinationExchangePattern;
    protected String id;
    protected String routeId;
    protected boolean extendedStatistics;
    protected final AtomicLong counter = new AtomicLong();

    public SendProcessor(Endpoint destination) {
        this(destination, null);
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        ObjectHelper.notNull((Object)destination, (String)"destination");
        this.destination = destination;
        this.camelContext = destination.getCamelContext();
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        this.pattern = pattern;
        this.destinationExchangePattern = null;
        this.destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl((String)destination.getEndpointUri());
    }

    public String toString() {
        return this.destination != null ? this.destination.toString() : this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTraceLabel() {
        if (this.traceLabelToString == null) {
            this.traceLabelToString = URISupport.sanitizeUri((String)this.destination.getEndpointUri());
        }
        return this.traceLabelToString;
    }

    public Endpoint getEndpoint() {
        return this.destination;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("SendProcessor has not been started: " + String.valueOf((Object)this)));
            callback.done(true);
            return true;
        }
        ExchangePattern existingPattern = exchange.getPattern();
        Object body = null;
        Map headers = null;
        if (this.variableSend != null || this.variableReceive != null) {
            try {
                body = exchange.getMessage().getBody();
                headers = this.headersMapFactory.newMap(exchange.getMessage().getHeaders());
            }
            catch (Exception throwable) {
                exchange.setException((Throwable)throwable);
                callback.done(true);
                return true;
            }
        }
        Object originalBody = body;
        Map originalHeaders = headers;
        if (this.extendedStatistics) {
            this.counter.incrementAndGet();
        }
        if (this.producer != null) {
            boolean newCallback;
            Exchange target = exchange;
            if (this.destinationExchangePattern != null || this.pattern != null) {
                target.setPattern(this.destinationExchangePattern != null ? this.destinationExchangePattern : this.pattern);
            }
            exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)this.destination.getEndpointUri());
            boolean sending = this.camelContext.getCamelContextExtension().isEventNotificationApplicable() && EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)target, (Endpoint)this.destination);
            StopWatch watch = sending ? new StopWatch() : null;
            AsyncCallback ac = callback;
            boolean bl = newCallback = watch != null || existingPattern != target.getPattern() || this.variableReceive != null;
            if (newCallback) {
                ac = doneSync -> {
                    try {
                        if (ExchangeHelper.shouldSetVariableResult((Exchange)target, (String)this.variableReceive)) {
                            ExchangeHelper.setVariableFromMessageBodyAndHeaders((Exchange)target, (String)this.variableReceive, (Message)target.getMessage());
                            target.getMessage().setBody(originalBody);
                            target.getMessage().setHeaders(originalHeaders);
                        }
                        target.setPattern(existingPattern);
                        if (watch != null) {
                            long timeTaken = watch.taken();
                            EventHelper.notifyExchangeSent((CamelContext)target.getContext(), (Exchange)target, (Endpoint)this.destination, (long)timeTaken);
                        }
                    }
                    finally {
                        callback.done(doneSync);
                    }
                };
            }
            try {
                if (this.variableSend != null) {
                    Object value = ExchangeHelper.getVariable((Exchange)exchange, (String)this.variableSend);
                    exchange.getMessage().setBody(value);
                }
                LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
                boolean sync = this.producer.process(exchange, ac);
                if (!sync) {
                    EventHelper.notifyExchangeAsyncProcessingStartedEvent((CamelContext)this.camelContext, (Exchange)exchange);
                }
                return sync;
            }
            catch (Exception throwable) {
                exchange.setException((Throwable)throwable);
                callback.done(true);
                return true;
            }
        }
        if (this.destinationExchangePattern != null || this.pattern != null) {
            exchange.setPattern(this.destinationExchangePattern != null ? this.destinationExchangePattern : this.pattern);
        }
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)this.destination.getEndpointUri());
        if (this.variableSend != null) {
            Object value = ExchangeHelper.getVariable((Exchange)exchange, (String)this.variableSend);
            exchange.getMessage().setBody(value);
        }
        LOG.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
        return this.producerCache.doInAsyncProducer(this.destination, exchange, callback, (producer, ex, cb) -> producer.process(ex, doneSync -> {
            exchange.setPattern(existingPattern);
            if (ExchangeHelper.shouldSetVariableResult((Exchange)exchange, (String)this.variableReceive)) {
                ExchangeHelper.setVariableFromMessageBodyAndHeaders((Exchange)exchange, (String)this.variableReceive, (Message)exchange.getMessage());
                exchange.getMessage().setBody(originalBody);
                exchange.getMessage().setHeaders(originalHeaders);
            }
            cb.done(doneSync);
        }));
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void reset() {
        this.counter.set(0L);
    }

    protected void doInit() throws Exception {
        this.extendedStatistics = this.camelContext.getManagementStrategy() != null && this.camelContext.getManagementStrategy().getManagementAgent() != null ? this.camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
        if (!this.destination.isSingletonProducer() && this.producerCache == null) {
            this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, 0);
        }
        this.headersMapFactory = this.camelContext.getCamelContextExtension().getHeadersMapFactory();
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Service)this.destination);
        if (this.destination.isSingletonProducer()) {
            this.producer = this.destination.createAsyncProducer();
            AsyncProducer asyncProducer = this.producer;
            if (asyncProducer instanceof RouteIdAware) {
                RouteIdAware ria = (RouteIdAware)asyncProducer;
                ria.setRouteId(this.getRouteId());
            }
            this.camelContext.addService((Object)this.producer, true, true);
        } else {
            ServiceHelper.startService((Service)this.producerCache);
        }
    }

    protected void doStop() throws Exception {
        if (this.producer != null) {
            this.camelContext.removeService((Object)this.producer);
        }
        ServiceHelper.stopService((Object[])new Object[]{this.producerCache, this.producer});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producerCache, this.producer});
    }
}

