/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import jakarta.enterprise.concurrent.ManagedExecutors;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;

public class ConcurrentTaskExecutor
implements AsyncListenableTaskExecutor,
SchedulingTaskExecutor {
    private static final Executor STUB_EXECUTOR = task -> {
        throw new IllegalStateException("Executor not configured");
    };
    @Nullable
    private static Class<?> managedExecutorServiceClass;
    private Executor concurrentExecutor = STUB_EXECUTOR;
    private TaskExecutorAdapter adaptedExecutor = new TaskExecutorAdapter(STUB_EXECUTOR);
    @Nullable
    private TaskDecorator taskDecorator;

    @Deprecated(since="6.1")
    public ConcurrentTaskExecutor() {
        this.concurrentExecutor = Executors.newSingleThreadExecutor();
        this.adaptedExecutor = new TaskExecutorAdapter(this.concurrentExecutor);
    }

    public ConcurrentTaskExecutor(@Nullable Executor executor) {
        if (executor != null) {
            this.setConcurrentExecutor(executor);
        }
    }

    public final void setConcurrentExecutor(Executor executor) {
        this.concurrentExecutor = executor;
        this.adaptedExecutor = this.getAdaptedExecutor(this.concurrentExecutor);
    }

    public final Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
        this.adaptedExecutor.setTaskDecorator(taskDecorator);
    }

    @Override
    public void execute(Runnable task) {
        this.adaptedExecutor.execute(task);
    }

    @Override
    @Deprecated
    public void execute(Runnable task, long startTimeout) {
        this.adaptedExecutor.execute(task, startTimeout);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.adaptedExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.adaptedExecutor.submit(task);
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.adaptedExecutor.submitListenable(task);
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.adaptedExecutor.submitListenable(task);
    }

    private TaskExecutorAdapter getAdaptedExecutor(Executor originalExecutor) {
        TaskExecutorAdapter adapter;
        TaskExecutorAdapter taskExecutorAdapter = adapter = managedExecutorServiceClass != null && managedExecutorServiceClass.isInstance(originalExecutor) ? new ManagedTaskExecutorAdapter(originalExecutor) : new TaskExecutorAdapter(originalExecutor);
        if (this.taskDecorator != null) {
            adapter.setTaskDecorator(this.taskDecorator);
        }
        return adapter;
    }

    static {
        try {
            managedExecutorServiceClass = ClassUtils.forName("jakarta.enterprise.concurrent.ManagedExecutorService", ConcurrentTaskScheduler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            managedExecutorServiceClass = null;
        }
    }

    private static class ManagedTaskExecutorAdapter
    extends TaskExecutorAdapter {
        public ManagedTaskExecutorAdapter(Executor concurrentExecutor) {
            super(concurrentExecutor);
        }

        @Override
        public void execute(Runnable task) {
            super.execute(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public Future<?> submit(Runnable task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public ListenableFuture<?> submitListenable(Runnable task) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }

        @Override
        public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task, task.toString()));
        }
    }

    protected static class ManagedTaskBuilder {
        protected ManagedTaskBuilder() {
        }

        public static Runnable buildManagedTask(Runnable task, String identityName) {
            HashMap<String, String> properties;
            if (task instanceof SchedulingAwareRunnable) {
                SchedulingAwareRunnable schedulingAwareRunnable = (SchedulingAwareRunnable)task;
                properties = new HashMap(4);
                properties.put("jakarta.enterprise.concurrent.LONGRUNNING_HINT", Boolean.toString(schedulingAwareRunnable.isLongLived()));
            } else {
                properties = new HashMap<String, String>(2);
            }
            properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask((Runnable)task, properties, null);
        }

        public static <T> Callable<T> buildManagedTask(Callable<T> task, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask(task, properties, null);
        }
    }
}

