/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import jakarta.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.ImplicitObjects;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class JSTLVariableResolver
implements VariableResolver {
    @Override
    public Object resolveVariable(String pName, Object pContext) throws ELException {
        PageContext ctx = (PageContext)pContext;
        if ("pageContext".equals(pName)) {
            return ctx;
        }
        if ("pageScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getPageScopeMap();
        }
        if ("requestScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getRequestScopeMap();
        }
        if ("sessionScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getSessionScopeMap();
        }
        if ("applicationScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getApplicationScopeMap();
        }
        if ("param".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getParamMap();
        }
        if ("paramValues".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getParamsMap();
        }
        if ("header".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getHeaderMap();
        }
        if ("headerValues".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getHeadersMap();
        }
        if ("initParam".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getInitParamMap();
        }
        if ("cookie".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(ctx).getCookieMap();
        }
        return ctx.findAttribute(pName);
    }
}

