/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShutdownStrategy
extends ServiceSupport
implements ShutdownStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShutdownStrategy.class);
    private final CamelLogger logger = new CamelLogger(LOG, LoggingLevel.DEBUG);
    private CamelContext camelContext;
    private ExecutorService executor;
    private long timeout = 45L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;
    private boolean suppressLoggingOnTimeout;
    private boolean logInflightExchangesOnTimeout = true;
    private boolean forceShutdown;
    private final AtomicBoolean timeoutOccurred = new AtomicBoolean();
    private volatile Future<?> currentShutdownTaskFuture;

    public DefaultShutdownStrategy() {
    }

    public DefaultShutdownStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void shutdown(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.shutdown(context, routes, this.getTimeout(), this.getTimeUnit());
    }

    public void shutdownForced(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), false, false, true);
    }

    public void suspend(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), true, false, false);
    }

    public void shutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, false, false, false);
    }

    public boolean shutdown(CamelContext context, RouteStartupOrder route, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        List<RouteStartupOrder> routes = Collections.singletonList(route);
        return this.doShutdown(context, routes, timeout, timeUnit, false, abortAfterTimeout, false);
    }

    public void suspend(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doShutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly, boolean abortAfterTimeout, boolean forceShutdown) throws Exception {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        if (routes.isEmpty()) {
            return true;
        }
        StopWatch watch = new StopWatch();
        Comparator<RouteStartupOrder> comparator = Comparator.comparingInt(RouteStartupOrder::getStartupOrder);
        if (this.shutdownRoutesInReverseOrder) {
            comparator = comparator.reversed();
        }
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(routes);
        routesOrdered.sort(comparator);
        if (this.logger.shouldLog()) {
            String action = suspendOnly ? "suspend" : "shutdown";
            String msg = String.format("Starting to graceful %s %s routes (timeout %s %s)", action, routesOrdered.size(), timeout, timeUnit.toString().toLowerCase(Locale.ENGLISH));
            this.logger.log(msg);
        }
        this.timeoutOccurred.set(false);
        try {
            this.currentShutdownTaskFuture = this.getExecutorService().submit(new ShutdownTask(context, routesOrdered, timeout, timeUnit, suspendOnly, abortAfterTimeout, this.timeoutOccurred, this.isLogInflightExchangesOnTimeout()));
            this.currentShutdownTaskFuture.get(timeout, timeUnit);
        }
        catch (RejectedExecutionException action) {
        }
        catch (ExecutionException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e.getCause());
        }
        catch (Exception e) {
            this.timeoutOccurred.set(true);
            if (this.currentShutdownTaskFuture != null) {
                this.currentShutdownTaskFuture.cancel(true);
            }
            this.forceShutdown = forceShutdown;
            if (!forceShutdown && abortAfterTimeout) {
                LOG.warn("Timeout occurred during graceful shutdown. Aborting the shutdown now. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                this.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
                boolean bl = false;
                return bl;
            }
            if (forceShutdown || this.shutdownNowOnTimeout) {
                LOG.warn("Timeout occurred during graceful shutdown. Forcing the routes to be shutdown now. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                this.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
                this.shutdownRoutesNow(routesOrdered);
                for (RouteStartupOrder order : routes) {
                    for (Service service : order.getServices()) {
                        this.prepareShutdown(service, false, true, true, this.isSuppressLoggingOnTimeout());
                    }
                }
            } else {
                LOG.warn("Timeout occurred during graceful shutdown. Will ignore shutting down the remainder routes. Notice: some resources may still be running as graceful shutdown did not complete successfully.");
                this.logInflightExchanges(context, routes, this.isLogInflightExchangesOnTimeout());
            }
        }
        finally {
            this.currentShutdownTaskFuture = null;
        }
        if (this.logger.shouldLog()) {
            this.logger.log(String.format("Graceful shutdown of %s routes completed in %s", routesOrdered.size(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)));
        }
        return true;
    }

    public boolean isForceShutdown() {
        return this.forceShutdown;
    }

    public boolean hasTimeoutOccurred() {
        return this.timeoutOccurred.get();
    }

    public void setTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive value");
        }
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.shutdownNowOnTimeout = shutdownNowOnTimeout;
    }

    public boolean isShutdownNowOnTimeout() {
        return this.shutdownNowOnTimeout;
    }

    public boolean isShutdownRoutesInReverseOrder() {
        return this.shutdownRoutesInReverseOrder;
    }

    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.shutdownRoutesInReverseOrder = shutdownRoutesInReverseOrder;
    }

    public boolean isSuppressLoggingOnTimeout() {
        return this.suppressLoggingOnTimeout;
    }

    public void setSuppressLoggingOnTimeout(boolean suppressLoggingOnTimeout) {
        this.suppressLoggingOnTimeout = suppressLoggingOnTimeout;
    }

    public boolean isLogInflightExchangesOnTimeout() {
        return this.logInflightExchangesOnTimeout;
    }

    public void setLogInflightExchangesOnTimeout(boolean logInflightExchangesOnTimeout) {
        this.logInflightExchangesOnTimeout = logInflightExchangesOnTimeout;
    }

    public LoggingLevel getLoggingLevel() {
        return this.logger.getLevel();
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.logger.setLevel(loggingLevel);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Future<?> getCurrentShutdownTaskFuture() {
        return this.currentShutdownTaskFuture;
    }

    protected void shutdownRoutesNow(List<RouteStartupOrder> routes) {
        for (RouteStartupOrder order : routes) {
            ShutdownRunningTask current = order.getRoute().getShutdownRunningTask();
            if (current != ShutdownRunningTask.CompleteCurrentTaskOnly) {
                LOG.debug("Changing shutdownRunningTask from {} to {} on route {} to shutdown faster", new Object[]{ShutdownRunningTask.CompleteCurrentTaskOnly, current, order.getRoute().getId()});
                order.getRoute().setShutdownRunningTask(ShutdownRunningTask.CompleteCurrentTaskOnly);
            }
            order.getRoute().getProperties().put("forcedShutdown", true);
            this.shutdownNow(order.getRoute().getId(), order.getInput());
        }
    }

    protected void shutdownNow(String routeId, List<Consumer> consumers) {
        for (Consumer consumer : consumers) {
            this.shutdownNow(routeId, consumer);
        }
    }

    protected void shutdownNow(String routeId, Consumer consumer) {
        LOG.trace("Shutting down: {}", (Object)consumer);
        try {
            ServiceHelper.stopService((Service)consumer);
        }
        catch (Exception e) {
            LOG.warn("Error occurred while shutting down route: {}. This exception will be ignored.", (Object)routeId, (Object)e);
            EventHelper.notifyServiceStopFailure((CamelContext)consumer.getEndpoint().getCamelContext(), (Object)consumer, (Throwable)e);
        }
        LOG.trace("Shutdown complete for: {}", (Object)consumer);
    }

    protected void suspendNow(String routeId, Consumer consumer) {
        LOG.trace("Suspending: {}", (Object)consumer);
        try {
            ServiceHelper.suspendService((Object)consumer);
        }
        catch (Exception e) {
            LOG.warn("Error occurred while suspending route: {}. This exception will be ignored.", (Object)routeId, (Object)e);
            EventHelper.notifyServiceStopFailure((CamelContext)consumer.getEndpoint().getCamelContext(), (Object)consumer, (Throwable)e);
        }
        LOG.trace("Suspend complete for: {}", (Object)consumer);
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = this.camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "ShutdownTask");
        }
        return this.executor;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        this.forceShutdown = false;
        this.timeoutOccurred.set(false);
    }

    protected void doShutdown() throws Exception {
        if (this.executor != null) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    private void prepareShutdown(Service service, boolean suspendOnly, boolean forced, boolean includeChildren, boolean suppressLogging) {
        LinkedHashSet<Service> list;
        if (includeChildren) {
            list = ServiceHelper.getChildServices((Service)service, (boolean)true);
        } else {
            list = new LinkedHashSet<Service>(1);
            list.add(service);
        }
        for (Service child : list) {
            if (!(child instanceof ShutdownPrepared)) continue;
            try {
                LOG.trace("Preparing (forced: {}) shutdown on: {}", (Object)forced, (Object)child);
                ((ShutdownPrepared)child).prepareShutdown(suspendOnly, forced);
            }
            catch (Exception e) {
                if (suppressLogging) {
                    LOG.trace("Error during prepare shutdown on {}. This exception will be ignored.", (Object)child, (Object)e);
                    continue;
                }
                LOG.warn("Error during prepare shutdown on {}. This exception will be ignored.", (Object)child, (Object)e);
            }
        }
    }

    protected static int getPendingInflightExchanges(RouteStartupOrder order) {
        int inflight = 0;
        for (Service service : order.getServices()) {
            Set children = ServiceHelper.getChildServices((Service)service);
            for (Service child : children) {
                if (!(child instanceof ShutdownAware)) continue;
                inflight += ((ShutdownAware)child).getPendingExchangesSize();
            }
        }
        return inflight;
    }

    protected void logInflightExchanges(CamelContext camelContext, List<RouteStartupOrder> routes, boolean infoLevel) {
        if (!infoLevel && !LOG.isDebugEnabled()) {
            return;
        }
        Collection inflights = camelContext.getInflightRepository().browse();
        int size = inflights.size();
        if (size == 0) {
            return;
        }
        HashSet<String> routeIds = new HashSet<String>();
        for (RouteStartupOrder routeStartupOrder : routes) {
            routeIds.add(routeStartupOrder.getRoute().getId());
        }
        ArrayList<InflightRepository.InflightExchange> filtered = new ArrayList<InflightRepository.InflightExchange>();
        for (InflightRepository.InflightExchange inflight : inflights) {
            String routeId = inflight.getExchange().getFromRouteId();
            if (!routeIds.contains(routeId)) continue;
            filtered.add(inflight);
        }
        size = filtered.size();
        if (size == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("There are " + size + " inflight exchanges:");
        for (InflightRepository.InflightExchange inflight : filtered) {
            stringBuilder.append("\n\tInflightExchange: [exchangeId=").append(inflight.getExchange().getExchangeId()).append(", fromRouteId=").append(inflight.getExchange().getFromRouteId()).append(", atRouteId=").append(inflight.getAtRouteId()).append(", nodeId=").append(inflight.getNodeId()).append(", elapsed=").append(inflight.getElapsed()).append(", duration=").append(inflight.getDuration()).append("]");
        }
        if (infoLevel) {
            LOG.info(stringBuilder.toString());
        } else {
            LOG.debug(stringBuilder.toString());
        }
    }

    class ShutdownTask
    implements Runnable {
        private final CamelContext context;
        private final List<RouteStartupOrder> routes;
        private final boolean suspendOnly;
        private final boolean abortAfterTimeout;
        private final long timeout;
        private final TimeUnit timeUnit;
        private final AtomicBoolean timeoutOccurred;
        private final boolean logInflightExchangesOnTimeout;

        ShutdownTask(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly, boolean abortAfterTimeout, AtomicBoolean timeoutOccurred, boolean logInflightExchangesOnTimeout) {
            this.context = context;
            this.routes = routes;
            this.suspendOnly = suspendOnly;
            this.abortAfterTimeout = abortAfterTimeout;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.timeoutOccurred = timeoutOccurred;
            this.logInflightExchangesOnTimeout = logInflightExchangesOnTimeout;
        }

        @Override
        public void run() {
            Consumer consumer;
            LOG.debug("There are {} routes to {}", (Object)this.routes.size(), (Object)(this.suspendOnly ? "suspend" : "shutdown"));
            ArrayList<ShutdownDeferredConsumer> deferredConsumers = new ArrayList<ShutdownDeferredConsumer>();
            for (RouteStartupOrder order : this.routes) {
                Object uri;
                boolean shutdown;
                ShutdownRoute shutdownRoute = order.getRoute().getShutdownRoute();
                ShutdownRunningTask shutdownRunningTask = order.getRoute().getShutdownRunningTask();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}{} with options [{},{}]", new Object[]{this.suspendOnly ? "Suspending route: " : "Shutting down route: ", order.getRoute().getId(), shutdownRoute, shutdownRunningTask});
                }
                Consumer consumer2 = order.getInput();
                boolean suspend = false;
                boolean bl = shutdown = shutdownRoute != ShutdownRoute.Defer;
                if (shutdown) {
                    if (consumer2 instanceof ShutdownAware) {
                        boolean bl2 = shutdown = !((ShutdownAware)consumer2).deferShutdown(shutdownRunningTask);
                    }
                    if (shutdown && consumer2 instanceof Suspendable) {
                        suspend = true;
                    }
                }
                if (suspend) {
                    DefaultShutdownStrategy.this.suspendNow(order.getRoute().getId(), consumer2);
                    deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer2));
                    uri = order.getRoute().getEndpoint().getEndpointBaseUri();
                    uri = URISupport.sanitizeUri((String)uri);
                    LOG.debug("Route: {} suspended and shutdown deferred, was consuming from: {}", (Object)order.getRoute().getId(), uri);
                    continue;
                }
                if (shutdown) {
                    DefaultShutdownStrategy.this.shutdownNow(order.getRoute().getId(), consumer2);
                    uri = order.getRoute().getEndpoint().getEndpointBaseUri();
                    uri = URISupport.sanitizeUri((String)uri);
                    if (!DefaultShutdownStrategy.this.logger.shouldLog()) continue;
                    DefaultShutdownStrategy.this.logger.log(String.format("Route: %s shutdown complete, was consuming from: %s", order.getRoute().getId(), uri));
                    continue;
                }
                deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer2));
                LOG.debug("Route: {} {}", (Object)order.getRoute().getId(), (Object)(this.suspendOnly ? "shutdown deferred." : "suspension deferred."));
            }
            for (RouteStartupOrder order : this.routes) {
                for (Service service : order.getServices()) {
                    if (service instanceof Consumer) continue;
                    DefaultShutdownStrategy.this.prepareShutdown(service, this.suspendOnly, false, true, false);
                }
            }
            boolean done = false;
            long loopDelaySeconds = 1L;
            long loopCount = 0L;
            while (!done && !this.timeoutOccurred.get()) {
                int size = 0;
                LinkedHashMap<String, Integer> routeInflight = new LinkedHashMap<String, Integer>();
                for (RouteStartupOrder routeStartupOrder : this.routes) {
                    int inflight = this.context.getInflightRepository().size(routeStartupOrder.getRoute().getId());
                    if ((inflight += DefaultShutdownStrategy.getPendingInflightExchanges(routeStartupOrder)) <= 0) continue;
                    String routeId = routeStartupOrder.getRoute().getId();
                    routeInflight.put(routeId, inflight);
                    size += inflight;
                    LOG.trace("{} inflight and pending exchanges for route: {}", (Object)inflight, (Object)routeId);
                }
                if (size > 0) {
                    try {
                        StringJoiner inflightsBuilder = new StringJoiner(", ", " Inflights per route: [", "]");
                        for (Map.Entry entry : routeInflight.entrySet()) {
                            String row = String.format("%s = %s", entry.getKey(), entry.getValue());
                            inflightsBuilder.add(row);
                        }
                        String string2 = "Waiting as there are still " + size + " inflight and pending exchanges to complete, timeout in " + (TimeUnit.SECONDS.convert(this.timeout, this.timeUnit) - loopCount++ * loopDelaySeconds) + " seconds.";
                        string2 = string2 + inflightsBuilder.toString();
                        LOG.info(string2);
                        DefaultShutdownStrategy.this.logInflightExchanges(this.context, this.routes, this.logInflightExchangesOnTimeout);
                        Thread.sleep(loopDelaySeconds * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (this.abortAfterTimeout) {
                            LOG.warn("Interrupted while waiting during graceful shutdown, will abort.");
                            return;
                        }
                        LOG.warn("Interrupted while waiting during graceful shutdown, will force shutdown now.");
                        break;
                    }
                }
                done = true;
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                consumer = deferred.getConsumer();
                if (!(consumer instanceof ShutdownAware)) continue;
                LOG.trace("Route: {} preparing to shutdown.", (Object)deferred.getRoute().getId());
                boolean bl = this.context.getShutdownStrategy().isForceShutdown();
                boolean suppress = this.context.getShutdownStrategy().isSuppressLoggingOnTimeout();
                DefaultShutdownStrategy.this.prepareShutdown((Service)consumer, this.suspendOnly, bl, false, suppress);
                LOG.debug("Route: {} preparing to shutdown complete.", (Object)deferred.getRoute().getId());
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                consumer = deferred.getConsumer();
                if (this.suspendOnly) {
                    DefaultShutdownStrategy.this.suspendNow(deferred.getRoute().getId(), consumer);
                    String string3 = deferred.getRoute().getEndpoint().getEndpointBaseUri();
                    string3 = URISupport.sanitizeUri((String)string3);
                    if (!DefaultShutdownStrategy.this.logger.shouldLog()) continue;
                    DefaultShutdownStrategy.this.logger.log(String.format("Route: %s suspend complete, was consuming from: %s", deferred.getRoute().getId(), string3));
                    continue;
                }
                DefaultShutdownStrategy.this.shutdownNow(deferred.getRoute().getId(), consumer);
                String string4 = deferred.getRoute().getEndpoint().getEndpointBaseUri();
                string4 = URISupport.sanitizeUri((String)string4);
                if (!DefaultShutdownStrategy.this.logger.shouldLog()) continue;
                DefaultShutdownStrategy.this.logger.log(String.format("Route: %s shutdown complete, was consuming from: %s", deferred.getRoute().getId(), string4));
            }
            for (RouteStartupOrder order : this.routes) {
                for (Service service : order.getServices()) {
                    boolean forced = this.context.getShutdownStrategy().isForceShutdown();
                    boolean suppress = this.context.getShutdownStrategy().isSuppressLoggingOnTimeout();
                    DefaultShutdownStrategy.this.prepareShutdown(service, this.suspendOnly, forced, true, suppress);
                }
            }
        }
    }

    static class ShutdownDeferredConsumer {
        private final Route route;
        private final Consumer consumer;

        ShutdownDeferredConsumer(Route route, Consumer consumer) {
            this.route = route;
            this.consumer = consumer;
        }

        Route getRoute() {
            return this.route;
        }

        Consumer getConsumer() {
            return this.consumer;
        }
    }
}

