/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerLoader;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationTransformerLoader
extends Transformer
implements TransformerLoader,
CamelContextAware {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/Transformer";
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationTransformerLoader.class);
    private CamelContext camelContext;
    private String packageName;
    private PackageScanClassResolver resolver;
    private final Set<Class<?>> visitedClasses = new HashSet();
    private final Set<String> visitedURIs = new HashSet<String>();

    public void load(TransformerRegistry registry) {
        Set scannedClasses;
        HashSet<String> packages;
        block10: {
            ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
            if (this.resolver == null) {
                this.resolver = this.camelContext instanceof ExtendedCamelContext ? PluginHelper.getPackageScanClassResolver((CamelContext)this.camelContext) : new DefaultPackageScanClassResolver();
            }
            packages = new HashSet<String>();
            if (this.packageName == null || this.packageName.equals("*")) {
                LOG.trace("Searching for {} services", (Object)META_INF_SERVICES);
                try {
                    ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                    if (ccl != null) {
                        this.findPackages(packages, ccl);
                    }
                    this.findPackages(packages, ((Object)((Object)this)).getClass().getClassLoader());
                    if (packages.isEmpty()) {
                        LOG.debug("No package names found to be used for classpath scanning for annotated data types.");
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    throw new TypeConverterLoaderException("Cannot find package names to be used for classpath scanning for annotated data types.", (Throwable)e);
                }
            }
            packages.add(this.packageName);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found data type packages to scan: {}", (Object)String.join((CharSequence)", ", packages));
        }
        if (!(scannedClasses = this.resolver.findAnnotated(DataTypeTransformer.class, packages.toArray(new String[0]))).isEmpty()) {
            LOG.debug("Found {} packages with {} @DataType classes to load", (Object)packages.size(), (Object)scannedClasses.size());
            for (Class type : scannedClasses) {
                if (!this.acceptClass(type)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loading data type annotation: {}", (Object)ObjectHelper.name((Class)type));
                }
                this.registerTransformer(registry, type);
            }
        }
        this.visitedClasses.clear();
        this.visitedURIs.clear();
    }

    private void registerTransformer(TransformerRegistry registry, Class<?> type) {
        if (this.visitedClasses.contains(type)) {
            return;
        }
        this.visitedClasses.add(type);
        try {
            if (Transformer.class.isAssignableFrom(type) && type.isAnnotationPresent(DataTypeTransformer.class)) {
                DataTypeTransformer dt = type.getAnnotation(DataTypeTransformer.class);
                Transformer transformer = (Transformer)this.camelContext.getInjector().newInstance(type);
                if (!ObjectHelper.isEmpty((String)dt.name())) {
                    registry.put((Object)new TransformerKey(dt.name()), (Object)transformer);
                }
                if (!DataType.isAnyType((DataType)new DataType(dt.fromType())) || !DataType.isAnyType((DataType)new DataType(dt.toType()))) {
                    registry.put((Object)new TransformerKey(new DataType(dt.fromType()), new DataType(dt.toType())), (Object)transformer);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("Ignoring transformer type: {} as a dependent class could not be found: {}", new Object[]{type.getCanonicalName(), e, e});
        }
    }

    protected boolean acceptClass(Class<?> type) {
        return Transformer.class.isAssignableFrom(type) && type.isAnnotationPresent(DataTypeTransformer.class);
    }

    protected void findPackages(Set<String> packages, ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String path = url.getPath();
            if (this.visitedURIs.contains(path)) continue;
            this.visitedURIs.add(path);
            LOG.debug("Loading file {} to retrieve list of packages, from url: {}", (Object)META_INF_SERVICES, (Object)url);
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                    packages.add(line);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public void transform(Message message, DataType from, DataType to) throws Exception {
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

