/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="configuration")
@XmlRootElement(name="transacted")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TransactedDefinition
extends OutputDefinition<TransactedDefinition> {
    @XmlTransient
    public static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    @XmlTransient
    private Class<? extends Policy> type = TransactedPolicy.class;
    @XmlTransient
    private Policy policy;
    @XmlAttribute
    private String ref;

    public TransactedDefinition() {
    }

    public TransactedDefinition(Policy policy) {
        this.policy = policy;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    @Override
    public String toString() {
        String desc = this.description();
        if (ObjectHelper.isEmpty((String)desc)) {
            return "Transacted";
        }
        return "Transacted[" + desc + "]";
    }

    protected String description() {
        if (this.ref != null) {
            return "ref:" + this.ref;
        }
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "";
    }

    @Override
    public String getShortName() {
        return "transacted";
    }

    @Override
    public String getLabel() {
        String desc = this.description();
        if (ObjectHelper.isEmpty((String)desc)) {
            return "transacted";
        }
        return "transacted[" + desc + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Class<? extends Policy> getType() {
        return this.type;
    }

    public void setType(Class<? extends Policy> type) {
        this.type = type;
    }

    public TransactedDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }
}

