/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.List;
import java.util.Map;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.HttpMethod;
import org.jolokia.server.core.util.RequestType;
import org.json.simple.JSONObject;

public abstract class JolokiaRequest {
    private final RequestType type;
    private ProcessingParameters processingConfig;
    private ValueFaultHandler valueFaultHandler;
    private final HttpMethod method;
    private final List<String> pathParts;
    private JSONObject options = null;
    private boolean exclusive = true;

    protected JolokiaRequest(RequestType pType, List<String> pPathParts, ProcessingParameters pProcessingParams, boolean pExclusive) {
        this(pType, HttpMethod.GET, pPathParts, pProcessingParams, pExclusive);
    }

    protected JolokiaRequest(Map<String, ?> pMap, ProcessingParameters pProcessingParams, boolean pExclusive) {
        this(RequestType.getTypeByName((String)pMap.get("type")), HttpMethod.POST, EscapeUtil.parsePath((String)pMap.get("path")), pProcessingParams, pExclusive);
        JSONObject reqOptions = (JSONObject)pMap.get("options");
        if (reqOptions != null) {
            this.options = reqOptions;
        }
        this.updateForLegacyProxyConfiguration(pMap);
    }

    private void updateForLegacyProxyConfiguration(Map<String, ?> pMap) {
        JSONObject targetOptions = (JSONObject)pMap.get("target");
        if (targetOptions != null) {
            if (this.options == null) {
                this.options = new JSONObject();
            }
            this.options.put((Object)"target", (Object)targetOptions);
            this.options.put((Object)"targetId", targetOptions.get((Object)"url"));
        }
    }

    private JolokiaRequest(RequestType pType, HttpMethod pMethod, List<String> pPathParts, ProcessingParameters pProcessingParams, boolean pExclusive) {
        this.method = pMethod;
        this.type = pType;
        this.verifyPath(pPathParts);
        this.pathParts = pPathParts;
        this.exclusive = pExclusive;
        this.initParameters(pProcessingParams);
    }

    public RequestType getType() {
        return this.type;
    }

    public String getParameter(ConfigKey pConfigKey) {
        return this.processingConfig.get(pConfigKey);
    }

    public int getParameterAsInt(ConfigKey pConfigKey) {
        String intValueS = this.processingConfig.get(pConfigKey);
        if (intValueS != null) {
            return Integer.parseInt(intValueS);
        }
        return 0;
    }

    public Boolean getParameterAsBool(ConfigKey pConfigKey) {
        String booleanS = this.getParameter(pConfigKey);
        return Boolean.parseBoolean(booleanS != null ? booleanS : pConfigKey.getDefaultValue());
    }

    public <T> T getOption(String pKey) {
        return (T)(this.options != null ? this.options.get((Object)pKey) : null);
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.valueFaultHandler;
    }

    public boolean useReturnValueWithPath() {
        return true;
    }

    protected String getInfo() {
        StringBuilder ret = new StringBuilder();
        if (this.pathParts != null) {
            ret.append(", path=").append(this.pathParts);
        }
        if (this.options != null) {
            ret.append(", options={");
            for (Map.Entry entry : this.options.entrySet()) {
                ret.append(entry.getKey()).append("=").append(entry.getValue());
            }
            ret.append("}");
        }
        return ret.length() > 0 ? ret.toString() : null;
    }

    public List<String> getPathParts() {
        return this.pathParts;
    }

    public String getPath() {
        return EscapeUtil.combineToPath(this.pathParts);
    }

    public JSONObject toJSON() {
        JSONObject ret = new JSONObject();
        ret.put((Object)"type", (Object)this.type.getName());
        if (this.options != null) {
            ret.put((Object)"options", (Object)this.options);
        }
        if (this.pathParts != null) {
            ret.put((Object)"path", (Object)this.getPath());
        }
        return ret;
    }

    private void initParameters(ProcessingParameters pParams) {
        this.processingConfig = pParams;
        String ignoreErrors = this.processingConfig.get(ConfigKey.IGNORE_ERRORS);
        this.valueFaultHandler = ignoreErrors != null && ignoreErrors.matches("^(true|yes|on|1)$") ? ValueFaultHandler.IGNORING_VALUE_FAULT_HANDLER : ValueFaultHandler.THROWING_VALUE_FAULT_HANDLER;
    }

    private void verifyPath(List<String> pPathParts) {
        if (pPathParts != null && !pPathParts.isEmpty() && pPathParts.get(pPathParts.size() - 1) == null) {
            String path = EscapeUtil.combineToPath(pPathParts);
            throw new IllegalArgumentException("Path '" + path + "' must not end with a wildcard");
        }
    }
}

