/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.osgi.security;

import jakarta.servlet.http.HttpServletRequest;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jolokia.server.core.osgi.security.AuthorizationHeaderParser;
import org.jolokia.server.core.osgi.security.BaseAuthenticator;
import org.jolokia.server.core.util.UserPasswordCallbackHandler;

public class JaasAuthenticator
extends BaseAuthenticator {
    private final String realm;

    public JaasAuthenticator(String pRealm) {
        this.realm = pRealm;
    }

    @Override
    protected boolean doAuthenticate(HttpServletRequest pRequest, AuthorizationHeaderParser.Result pAuthInfo) {
        try {
            String user = pAuthInfo.getUser();
            String password = pAuthInfo.getPassword();
            UserPasswordCallbackHandler handler = new UserPasswordCallbackHandler(user, password);
            LoginContext loginContext = this.createLoginContext(this.realm, handler);
            loginContext.login();
            pRequest.setAttribute("org.jolokia.jaasSubject", (Object)loginContext.getSubject());
            return true;
        }
        catch (LoginException e) {
            return false;
        }
    }

    protected LoginContext createLoginContext(String realm, CallbackHandler handler) throws LoginException {
        return new LoginContext(realm, handler);
    }
}

