/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;

public class StackedConfiguration
implements Configuration {
    private final List<Configuration> delegateConfigs;

    public StackedConfiguration(Configuration ... configs) {
        this.delegateConfigs = Arrays.asList(configs);
    }

    @Override
    public String getConfig(ConfigKey pKey) {
        for (Configuration config : this.delegateConfigs) {
            if (!config.containsKey(pKey)) continue;
            return config.getConfig(pKey);
        }
        return pKey.getDefaultValue();
    }

    @Override
    public Set<ConfigKey> getConfigKeys() {
        HashSet<ConfigKey> keys = new HashSet<ConfigKey>();
        for (Configuration config : this.delegateConfigs) {
            keys.addAll(config.getConfigKeys());
        }
        return keys;
    }

    @Override
    public boolean containsKey(ConfigKey pKey) {
        for (Configuration config : this.delegateConfigs) {
            if (!config.containsKey(pKey)) continue;
            return true;
        }
        return false;
    }
}

