/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.ProviderUtil;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;
import org.jolokia.service.jmx.handler.list.MBeanInfoData;
import org.json.simple.JSONObject;

public class ListHandler
extends AbstractCommandHandler<JolokiaListRequest> {
    @Override
    public RequestType getType() {
        return RequestType.LIST;
    }

    @Override
    public boolean handleAllServersAtOnce(JolokiaListRequest pRequest) {
        return true;
    }

    @Override
    protected void checkForRestriction(JolokiaListRequest pRequest) {
        this.checkType();
    }

    @Override
    public Object doHandleAllServerRequest(MBeanServerAccess pServerManager, JolokiaListRequest pRequest, Object pPreviousResult) throws IOException, NotChangedException {
        this.checkForModifiedSince(pServerManager, (JolokiaRequest)pRequest);
        Stack originalPathStack = EscapeUtil.reversePath((List)pRequest.getPathParts());
        int maxDepth = pRequest.getParameterAsInt(ConfigKey.MAX_DEPTH);
        boolean useCanonicalName = pRequest.getParameterAsBool(ConfigKey.CANONICAL_NAMING);
        ObjectName oName = null;
        try {
            Stack pathStack = (Stack)originalPathStack.clone();
            oName = this.objectNameFromPath(pathStack);
            if (oName != null) {
                if (ProviderUtil.matchesProvider((String)this.pProvider, (ObjectName)oName)) {
                    oName = ProviderUtil.extractProvider((ObjectName)oName).getObjectName();
                } else {
                    return pPreviousResult != null ? pPreviousResult : new JSONObject();
                }
            }
            ListMBeanEachAction action = new ListMBeanEachAction(maxDepth, pathStack, useCanonicalName, this.pProvider);
            return this.executeListAction(pServerManager, (Map)pPreviousResult, oName, action);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid path within the MBean part given. (Path: " + pRequest.getPath() + ")", e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("No MBean '" + oName + "' found", e);
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + e, e);
        }
    }

    private Object executeListAction(MBeanServerAccess pServerManager, Map<?, ?> pPreviousResult, ObjectName pName, ListMBeanEachAction pAction) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        if (pName == null || pName.isPattern()) {
            pServerManager.each(pName, (MBeanServerAccess.MBeanEachCallback)pAction);
        } else {
            pServerManager.call(pName, (MBeanServerAccess.MBeanAction)pAction, new Object[0]);
        }
        return pAction.getResult(pPreviousResult);
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaListRequest request) {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }

    private ObjectName objectNameFromPath(Stack<String> pPathStack) throws MalformedObjectNameException {
        if (pPathStack.empty()) {
            return null;
        }
        Stack path = (Stack)pPathStack.clone();
        String domain = (String)path.pop();
        if (path.empty()) {
            return new ObjectName(domain + ":*");
        }
        String props = (String)path.pop();
        ObjectName mbean = new ObjectName(domain + ":" + props);
        if (mbean.isPattern()) {
            throw new IllegalArgumentException("Cannot use an MBean pattern as path (given MBean: " + mbean + ")");
        }
        return mbean;
    }

    private static class ListMBeanEachAction
    implements MBeanServerAccess.MBeanEachCallback,
    MBeanServerAccess.MBeanAction<Void> {
        private final MBeanInfoData infoData;

        public ListMBeanEachAction(int pMaxDepth, Stack<String> pPathStack, boolean pUseCanonicalName, String pProvider) {
            this.infoData = new MBeanInfoData(pMaxDepth, pPathStack, pUseCanonicalName, pProvider);
        }

        public void callback(MBeanServerConnection pConn, ObjectName pName) throws ReflectionException, InstanceNotFoundException, IOException {
            this.lookupMBeanInfo(pConn, pName);
        }

        public Void execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException {
            this.lookupMBeanInfo(pConn, pName);
            return null;
        }

        private void lookupMBeanInfo(MBeanServerConnection pConn, ObjectName pName) throws InstanceNotFoundException, ReflectionException, IOException {
            if (!this.infoData.handleFirstOrSecondLevel(pName)) {
                try {
                    MBeanInfo mBeanInfo = pConn.getMBeanInfo(pName);
                    this.infoData.addMBeanInfo(mBeanInfo, pName);
                }
                catch (IOException exp) {
                    this.infoData.handleException(pName, exp);
                }
                catch (InstanceNotFoundException exp) {
                    this.infoData.handleException(pName, exp);
                }
                catch (IllegalStateException exp) {
                    this.infoData.handleException(pName, exp);
                }
                catch (IntrospectionException exp) {
                    throw new IllegalArgumentException("Cannot extra MBeanInfo for " + pName + ": " + exp, exp);
                }
            }
        }

        public Object getResult(Map pBaseMap) {
            Object result = this.infoData.applyPath();
            if (pBaseMap != null && result instanceof Map) {
                Map resultMap = (Map)result;
                for (Map.Entry entry : resultMap.entrySet()) {
                    pBaseMap.put(entry.getKey(), entry.getValue());
                }
                return pBaseMap;
            }
            return result;
        }
    }
}

