/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="from")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FromDefinition
extends OptionalIdentifiedDefinition<FromDefinition>
implements EndpointRequiredDefinition {
    @XmlTransient
    private RouteDefinition parent;
    @XmlTransient
    private Endpoint endpoint;
    @XmlTransient
    private EndpointConsumerBuilder endpointConsumerBuilder;
    @XmlAttribute
    @Metadata(required=true)
    private String uri;
    @XmlAttribute
    private String variableReceive;

    public FromDefinition() {
    }

    public FromDefinition(String uri) {
        this();
        this.setUri(uri);
    }

    public FromDefinition(Endpoint endpoint) {
        this();
        this.setEndpoint(endpoint);
    }

    public FromDefinition(EndpointConsumerBuilder endpointConsumerBuilder) {
        this();
        this.setEndpointConsumerBuilder(endpointConsumerBuilder);
    }

    public String toString() {
        return "From[" + this.getLabel() + "]";
    }

    public String getShortName() {
        return "from";
    }

    public String getLabel() {
        String uri = this.getEndpointUri();
        return uri != null ? uri : "no uri supplied";
    }

    @Override
    public String getEndpointUri() {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        if (this.endpointConsumerBuilder != null) {
            return this.endpointConsumerBuilder.getUri();
        }
        return null;
    }

    @Override
    public NamedNode getParent() {
        return this.parent;
    }

    public void setParent(RouteDefinition parent) {
        this.parent = parent;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.clear();
        this.uri = uri;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.clear();
        this.endpoint = endpoint;
    }

    public EndpointConsumerBuilder getEndpointConsumerBuilder() {
        return this.endpointConsumerBuilder;
    }

    public void setEndpointConsumerBuilder(EndpointConsumerBuilder endpointConsumerBuilder) {
        this.clear();
        this.endpointConsumerBuilder = endpointConsumerBuilder;
    }

    protected void clear() {
        this.endpointConsumerBuilder = null;
        this.endpoint = null;
        this.uri = null;
    }
}

