/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceCreator;
import org.jolokia.server.core.service.api.JolokiaServiceLookup;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.service.impl.ClasspathServerDetectorLookup;
import org.jolokia.server.core.service.impl.JolokiaContextImpl;
import org.jolokia.server.core.service.impl.MBeanRegistry;
import org.jolokia.server.core.service.impl.VersionRequestHandler;
import org.jolokia.server.core.service.request.RequestHandler;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.server.core.util.jmx.DefaultMBeanServerAccess;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.json.simple.parser.JSONParser;

public class JolokiaServiceManagerImpl
implements JolokiaServiceManager {
    private AgentDetails agentDetails;
    private final ServerDetectorLookup detectorLookup;
    private final Configuration configuration;
    private final LogHandler logHandler;
    private final Restrictor restrictor;
    private boolean isInitialized;
    private static final Class<?>[] SERVICE_TYPE_ORDER = new Class[]{ServerDetector.class, RequestHandler.class};
    private final List<JolokiaServiceLookup> serviceLookups;
    private final Map<Class<? extends JolokiaService<?>>, SortedSet<? extends JolokiaService<?>>> staticServices;
    private final Map<Class<? extends JolokiaService<?>>, JolokiaService<?>> staticLowServices;
    private JolokiaContextImpl jolokiaContext;
    private MBeanRegistry mbeanRegistry;
    private MBeanServerAccess mbeanServerAccess;

    public JolokiaServiceManagerImpl(Configuration pConfig, LogHandler pLogHandler, Restrictor pRestrictor, ServerDetectorLookup pDetectorLookup) {
        this.configuration = pConfig;
        this.logHandler = pLogHandler;
        this.restrictor = pRestrictor;
        this.isInitialized = false;
        this.serviceLookups = new ArrayList<JolokiaServiceLookup>();
        this.staticServices = new HashMap();
        this.staticLowServices = new HashMap();
        this.detectorLookup = pDetectorLookup != null ? pDetectorLookup : new ClasspathServerDetectorLookup();
        this.addService(new VersionRequestHandler());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public Restrictor getRestrictor() {
        return this.restrictor;
    }

    @Override
    public final synchronized void addService(JolokiaService<?> pService) {
        Class<?> type = pService.getType();
        SortedSet<JolokiaService<?>> servicesOfType = this.staticServices.get(type);
        if (servicesOfType == null) {
            servicesOfType = new TreeSet();
            this.staticServices.put(type, servicesOfType);
        }
        servicesOfType.add(pService);
        JolokiaService<?> pLowService = this.staticLowServices.get(type);
        if (pLowService == null || pLowService.getOrder() > pService.getOrder()) {
            this.staticLowServices.put(type, pService);
        }
    }

    @Override
    public void addServiceLookup(JolokiaServiceLookup pLookup) {
        this.serviceLookups.add(pLookup);
    }

    @Override
    public void addServices(JolokiaServiceCreator pServiceCreator) {
        for (JolokiaService<?> service : pServiceCreator.getServices()) {
            this.addService(service);
        }
    }

    @Override
    public synchronized JolokiaContext start() {
        if (!this.isInitialized) {
            SortedSet<ServerDetector> detectors = this.detectorLookup.lookup();
            this.mbeanServerAccess = this.createMBeanServerAccess(detectors);
            ServerHandle handle = this.detect(this.getDetectorOptions(), detectors, this.mbeanServerAccess);
            this.agentDetails = new AgentDetails(this.configuration, handle);
            this.jolokiaContext = new JolokiaContextImpl(this);
            this.mbeanRegistry = new MBeanRegistry();
            List<Class<JolokiaService<?>>> serviceTypes = this.getServiceTypes();
            for (Class<? extends JolokiaService<?>> clazz : serviceTypes) {
                Set services = this.staticServices.get(clazz);
                if (services == null) continue;
                for (JolokiaService service : services) {
                    service.init(this.jolokiaContext);
                }
            }
            for (JolokiaServiceLookup jolokiaServiceLookup : this.serviceLookups) {
                jolokiaServiceLookup.init(this.jolokiaContext);
            }
            this.isInitialized = true;
        }
        return this.jolokiaContext;
    }

    @Override
    public synchronized void stop() {
        if (this.isInitialized) {
            try {
                this.mbeanRegistry.destroy();
            }
            catch (JMException e) {
                this.logHandler.error("Cannot unregister own MBeans: " + e, e);
            }
            for (JolokiaServiceLookup jolokiaServiceLookup : this.serviceLookups) {
                jolokiaServiceLookup.destroy();
            }
            for (Class clazz : this.getServiceTypes()) {
                Set services = this.staticServices.get(clazz);
                if (services == null) continue;
                for (JolokiaService service : services) {
                    try {
                        service.destroy();
                    }
                    catch (Exception e) {
                        this.logHandler.error("Error while stopping service " + service + " of type " + service.getType() + ": " + e, e);
                    }
                }
            }
            this.isInitialized = false;
        }
    }

    public <T extends JolokiaService<?>> SortedSet<T> getServices(Class<T> pType) {
        SortedSet<? extends JolokiaService<?>> services = this.staticServices.get(pType);
        TreeSet ret = services != null ? new TreeSet(services) : new TreeSet();
        for (JolokiaServiceLookup factory : this.serviceLookups) {
            ret.addAll(factory.getServices(pType));
        }
        return ret;
    }

    public <T extends JolokiaService<?>> T getService(Class<T> pType) {
        JolokiaService ret = this.staticLowServices.get(pType);
        int order = ret != null ? ret.getOrder() : Integer.MAX_VALUE;
        for (JolokiaServiceLookup factory : this.serviceLookups) {
            for (JolokiaService service : factory.getServices(pType)) {
                if (service.getOrder() >= order) continue;
                ret = service;
                order = ret.getOrder();
            }
        }
        return (T)ret;
    }

    MBeanServerAccess getMBeanServerAccess() {
        return this.mbeanServerAccess;
    }

    private ServerHandle detect(Map<String, Object> pConfig, SortedSet<ServerDetector> detectors, MBeanServerAccess pMBeanServerAccess) {
        for (ServerDetector detector : detectors) {
            try {
                detector.init((Map)pConfig.get(detector.getName()));
                ServerHandle info = detector.detect(pMBeanServerAccess);
                if (info == null) continue;
                this.addInterceptor(detector, pMBeanServerAccess);
                return info;
            }
            catch (Exception exp) {
                this.logHandler.error("Error while using detector " + detector.getClass().getSimpleName() + ": " + exp, exp);
            }
        }
        return DefaultServerHandle.NULL_SERVER_HANDLE;
    }

    private void addInterceptor(ServerDetector detector, MBeanServerAccess pServerAccess) {
        RequestInterceptor interceptor = detector.getRequestInterceptor(pServerAccess);
        if (interceptor != null) {
            this.addService(interceptor);
        }
    }

    private MBeanServerAccess createMBeanServerAccess(SortedSet<ServerDetector> pDetectors) {
        HashSet<MBeanServerConnection> mbeanServers = new HashSet<MBeanServerConnection>();
        for (ServerDetector detector : pDetectors) {
            Set<MBeanServerConnection> found = detector.getMBeanServers();
            if (found == null) continue;
            mbeanServers.addAll(found);
        }
        return new DefaultMBeanServerAccess(mbeanServers);
    }

    private Map<String, Object> getDetectorOptions() {
        String optionString = this.configuration.getConfig(ConfigKey.DETECTOR_OPTIONS);
        if (optionString != null) {
            try {
                return (Map)new JSONParser().parse(optionString);
            }
            catch (Exception e) {
                this.logHandler.error("Could not parse detetctor options '" + optionString + "' as JSON object: " + e, e);
            }
        } else {
            return Collections.emptyMap();
        }
        return null;
    }

    private List<Class<? extends JolokiaService<?>>> getServiceTypes() {
        ArrayList ret = new ArrayList();
        for (Class<?> type : SERVICE_TYPE_ORDER) {
            ret.add(type);
        }
        for (Class clazz : this.staticServices.keySet()) {
            if (ret.contains(clazz)) continue;
            ret.add(clazz);
        }
        return ret;
    }

    public AgentDetails getAgentDetails() {
        return this.agentDetails;
    }

    public final ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        return this.mbeanRegistry.registerMBean(pMBean, pOptionalName);
    }

    public final void unregisterMBean(ObjectName pObjectName) throws MBeanRegistrationException {
        this.mbeanRegistry.unregisterMBean(pObjectName);
    }
}

