/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.serializer;

import org.jolokia.server.core.service.serializer.PathAttributeFilterValueFaultHandler;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;

public final class SerializeOptions {
    public static final SerializeOptions DEFAULT = new Builder().build();
    private final int maxDepth;
    private final int maxCollectionSize;
    private final int maxObjects;
    private final ValueFaultHandler faultHandler;

    private SerializeOptions(int pMaxDepth, int pMaxCollectionSize, int pMaxObjects, ValueFaultHandler pFaultHandler) {
        this.maxDepth = pMaxDepth;
        this.maxCollectionSize = pMaxCollectionSize;
        this.maxObjects = pMaxObjects;
        this.faultHandler = pFaultHandler;
    }

    public boolean maxDepthReached(int pDepth) {
        return this.maxDepth != 0 && pDepth >= this.maxDepth;
    }

    public boolean maxObjectExceeded(int pObjectCount) {
        return this.maxObjects != 0 && pObjectCount > this.maxObjects;
    }

    public int getCollectionSizeTruncated(int pCollectionSize) {
        return this.maxCollectionSize != 0 && pCollectionSize > this.maxCollectionSize ? this.maxCollectionSize : pCollectionSize;
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.faultHandler;
    }

    public static class Builder {
        private final int hardMaxDepth;
        private final int hardMaxCollectionSize;
        private final int hardMaxObjects;
        private int maxDepth;
        private int maxCollectionSize;
        private int maxObjects;
        private ValueFaultHandler faultHandler;
        private boolean useAttributeFilter;

        public Builder() {
            this(0, 0, 0);
        }

        public Builder(int pHardMaxDepth, int pHardMaxCollectionSize, int pHardMaxObjects) {
            this.hardMaxDepth = pHardMaxDepth;
            this.hardMaxCollectionSize = pHardMaxCollectionSize;
            this.hardMaxObjects = pHardMaxObjects;
            this.faultHandler = ValueFaultHandler.THROWING_VALUE_FAULT_HANDLER;
        }

        public Builder maxDepth(int pMaxDepth) {
            this.maxDepth = this.checkWithHardLimit(pMaxDepth, this.hardMaxDepth);
            return this;
        }

        public Builder maxCollectionSize(int pMaxCollectionSize) {
            this.maxCollectionSize = this.checkWithHardLimit(pMaxCollectionSize, this.hardMaxCollectionSize);
            return this;
        }

        public Builder maxObjects(int pMaxObjects) {
            this.maxObjects = this.checkWithHardLimit(pMaxObjects, this.hardMaxObjects);
            return this;
        }

        public Builder faultHandler(ValueFaultHandler pFaultHandler) {
            if (pFaultHandler != null) {
                this.faultHandler = pFaultHandler;
            }
            return this;
        }

        public Builder useAttributeFilter(boolean pUseFilter) {
            this.useAttributeFilter = pUseFilter;
            return this;
        }

        public SerializeOptions build() {
            ValueFaultHandler handler = this.useAttributeFilter ? new PathAttributeFilterValueFaultHandler(this.faultHandler) : this.faultHandler;
            SerializeOptions opts = new SerializeOptions(this.maxDepth, this.maxCollectionSize, this.maxObjects, handler);
            this.maxDepth = 0;
            this.maxCollectionSize = 0;
            this.maxObjects = 0;
            return opts;
        }

        private int checkWithHardLimit(int pLimit, int pHardLimit) {
            return pLimit < pHardLimit || pHardLimit == 0 ? pLimit : pHardLimit;
        }
    }
}

