/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.protocol;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.message.AMQPNativeInboundTransformer;
import org.apache.activemq.transport.amqp.message.AMQPRawInboundTransformer;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;
import org.apache.activemq.transport.amqp.message.JMSMappingInboundTransformer;
import org.apache.activemq.transport.amqp.protocol.AmqpAbstractReceiver;
import org.apache.activemq.transport.amqp.protocol.AmqpSession;
import org.apache.activemq.transport.amqp.protocol.ResponseHandler;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpReceiver
extends AmqpAbstractReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpReceiver.class);
    private final ProducerInfo producerInfo;
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private InboundTransformer inboundTransformer;
    private int sendsInFlight;

    public AmqpReceiver(AmqpSession session, Receiver endpoint, ProducerInfo producerInfo) {
        super(session, endpoint);
        this.producerInfo = producerInfo;
    }

    @Override
    public void close() {
        if (!this.isClosed() && this.isOpened()) {
            this.sendToActiveMQ(new RemoveInfo(this.getProducerId()), new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    AmqpReceiver.super.close();
                }
            });
        } else {
            super.close();
        }
    }

    public ProducerId getProducerId() {
        return this.producerInfo.getProducerId();
    }

    @Override
    public ActiveMQDestination getDestination() {
        return this.producerInfo.getDestination();
    }

    @Override
    public void setDestination(ActiveMQDestination destination) {
        this.producerInfo.setDestination(destination);
    }

    public boolean isAnonymous() {
        return this.producerInfo.getDestination() == null;
    }

    protected InboundTransformer getTransformer() {
        if (this.inboundTransformer == null) {
            String transformer = this.session.getConnection().getConfiguredTransformer();
            if (transformer.equalsIgnoreCase("jms")) {
                this.inboundTransformer = new JMSMappingInboundTransformer();
            } else if (transformer.equalsIgnoreCase("native")) {
                this.inboundTransformer = new AMQPNativeInboundTransformer();
            } else if (transformer.equalsIgnoreCase("raw")) {
                this.inboundTransformer = new AMQPRawInboundTransformer();
            } else {
                LOG.warn("Unknown transformer type {} using native one instead", (Object)transformer);
                this.inboundTransformer = new AMQPNativeInboundTransformer();
            }
        }
        return this.inboundTransformer;
    }

    @Override
    protected void processDelivery(Delivery delivery, Buffer deliveryBytes) throws Exception {
        if (!this.isClosed()) {
            EncodedMessage em = new EncodedMessage(delivery.getMessageFormat(), deliveryBytes.data, deliveryBytes.offset, deliveryBytes.length);
            InboundTransformer transformer = this.getTransformer();
            ActiveMQMessage message = transformer.transform(em);
            this.current = null;
            if (this.isAnonymous()) {
                Destination toDestination = message.getJMSDestination();
                if (toDestination == null || !(toDestination instanceof ActiveMQDestination)) {
                    Rejected rejected = new Rejected();
                    ErrorCondition condition = new ErrorCondition();
                    condition.setCondition(Symbol.valueOf((String)"failed"));
                    condition.setDescription("Missing to field for message sent to an anonymous producer");
                    rejected.setError(condition);
                    delivery.disposition((DeliveryState)rejected);
                    return;
                }
            } else {
                message.setJMSDestination(this.getDestination());
            }
            message.setProducerId(this.getProducerId());
            MessageId messageId = new MessageId(this.getProducerId(), this.messageIdGenerator.getNextSequenceId());
            MessageId amqpMessageId = message.getMessageId();
            if (amqpMessageId != null) {
                if (amqpMessageId.getTextView() != null) {
                    messageId.setTextView(amqpMessageId.getTextView());
                } else {
                    messageId.setTextView(amqpMessageId.toString());
                }
            }
            message.setMessageId(messageId);
            LOG.trace("Inbound Message:{} from Producer:{}", (Object)message.getMessageId(), (Object)(this.getProducerId() + ":" + messageId.getProducerSequenceId()));
            DeliveryState remoteState = delivery.getRemoteState();
            if (remoteState != null && remoteState instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)remoteState;
                LocalTransactionId txId = new LocalTransactionId(this.session.getConnection().getConnectionId(), AmqpSupport.toLong(txState.getTxnId()));
                this.session.enlist(txId);
                message.setTransactionId(txId);
            }
            message.onSend();
            ++this.sendsInFlight;
            this.sendToActiveMQ(message, this.createResponseHandler(delivery));
        }
    }

    private ResponseHandler createResponseHandler(final Delivery delivery) {
        return new ResponseHandler(){

            @Override
            public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                int n;
                if (!delivery.remotelySettled()) {
                    if (response.isException()) {
                        ExceptionResponse error = (ExceptionResponse)response;
                        Rejected rejected = new Rejected();
                        ErrorCondition condition = new ErrorCondition();
                        if (error.getException() instanceof SecurityException) {
                            condition.setCondition(AmqpError.UNAUTHORIZED_ACCESS);
                        } else if (error.getException() instanceof ResourceAllocationException) {
                            condition.setCondition(AmqpError.RESOURCE_LIMIT_EXCEEDED);
                        } else {
                            condition.setCondition(Symbol.valueOf((String)"failed"));
                        }
                        condition.setDescription(error.getException().getMessage());
                        rejected.setError(condition);
                        delivery.disposition((DeliveryState)rejected);
                    } else {
                        DeliveryState remoteState = delivery.getRemoteState();
                        if (remoteState != null && remoteState instanceof TransactionalState) {
                            TransactionalState txAccepted = new TransactionalState();
                            txAccepted.setOutcome((Outcome)Accepted.getInstance());
                            txAccepted.setTxnId(((TransactionalState)remoteState).getTxnId());
                            delivery.disposition((DeliveryState)txAccepted);
                        } else {
                            delivery.disposition((DeliveryState)Accepted.getInstance());
                        }
                    }
                }
                --AmqpReceiver.this.sendsInFlight;
                if ((double)(((Receiver)AmqpReceiver.this.getEndpoint()).getCredit() + n) <= (double)AmqpReceiver.this.getConfiguredReceiverCredit() * 0.3) {
                    LOG.trace("Sending more credit ({}) to producer: {}", (Object)((double)AmqpReceiver.this.getConfiguredReceiverCredit() * 0.7), (Object)AmqpReceiver.this.getProducerId());
                    ((Receiver)AmqpReceiver.this.getEndpoint()).flow((int)((double)AmqpReceiver.this.getConfiguredReceiverCredit() * 0.7));
                }
                delivery.settle();
                AmqpReceiver.this.session.pumpProtonToSocket();
            }
        };
    }
}

