/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.async;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncServletRequest
implements AsyncListener {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncServletRequest.class);
    private static final String ACTIVEMQ_ASYNC_SERVLET_REQUEST = "activemq.async.servlet.request";
    private final ServletRequest request;
    private final AtomicReference<AsyncContext> contextRef = new AtomicReference();
    private final AtomicBoolean dispatched = new AtomicBoolean();
    private final AtomicBoolean expired = new AtomicBoolean();
    private final AtomicLong timeoutMs = new AtomicLong(-1L);

    public AsyncServletRequest(ServletRequest request) {
        this.request = request;
    }

    public void complete() {
        AsyncContext context = this.getContext();
        context.complete();
    }

    public void startAsync() {
        this.dispatched.set(false);
        this.expired.set(false);
        AsyncContext context = this.request.startAsync();
        this.contextRef.set(context);
        context.setTimeout(this.timeoutMs.get());
        context.addListener((AsyncListener)this);
    }

    public void dispatch() {
        AsyncContext context = this.getContext();
        this.dispatched.set(true);
        context.dispatch();
    }

    public void setAttribute(String name, Object attribute) {
        this.request.setAttribute(name, attribute);
    }

    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs.set(timeoutMs);
    }

    public boolean isInitial() {
        return this.request.getDispatcherType() != DispatcherType.ASYNC;
    }

    public boolean isExpired() {
        return this.expired.get();
    }

    public boolean isDispatched() {
        return this.dispatched.get();
    }

    public AsyncContext getAsyncContext() {
        return this.contextRef.get();
    }

    public void onComplete(AsyncEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ActiveMQAsyncRequest " + event + " completed.");
        }
    }

    public void onTimeout(AsyncEvent event) {
        this.expired.set(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ActiveMQAsyncRequest " + event + " timeout.");
        }
    }

    public void onError(AsyncEvent event) {
        Throwable error = event.getThrowable();
        if (error != null) {
            LOG.warn("ActiveMQAsyncRequest " + event + " error: {}", (Object)error.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug(error.getMessage(), error);
            }
        }
    }

    public void onStartAsync(AsyncEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ActiveMQAsyncRequest " + event + " async started.");
        }
    }

    private AsyncContext getContext() {
        AsyncContext context = this.contextRef.get();
        if (context == null) {
            throw new IllegalStateException("Async request has not been started.");
        }
        return context;
    }

    public static AsyncServletRequest getAsyncRequest(ServletRequest request) {
        Objects.requireNonNull(request, "ServletRequest must not be null");
        return Optional.ofNullable(request.getAttribute(ACTIVEMQ_ASYNC_SERVLET_REQUEST)).map(sr -> (AsyncServletRequest)sr).orElseGet(() -> {
            AsyncServletRequest asyncRequest = new AsyncServletRequest(AsyncServletRequest.unwrap(request));
            request.setAttribute(ACTIVEMQ_ASYNC_SERVLET_REQUEST, (Object)asyncRequest);
            return asyncRequest;
        });
    }

    private static ServletRequest unwrap(ServletRequest request) {
        Objects.requireNonNull(request, "ServletRequest must not be null");
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return request;
    }
}

