/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassUtil {
    private static final Map<String, Class> PRIMITIVE_TO_OBJECT_MAP = new HashMap<String, Class>();

    private ClassUtil() {
    }

    public static <T> Class<T> classForName(String pClassName, ClassLoader ... pClassLoaders) {
        return ClassUtil.classForName(pClassName, true, pClassLoaders);
    }

    public static <T> Class<T> classForName(String pClassName, boolean pInitialize, ClassLoader ... pClassLoaders) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        Iterator<ClassLoader> iterator = ClassUtil.findClassLoaders(pClassLoaders).iterator();
        while (iterator.hasNext()) {
            for (ClassLoader loader = iterator.next(); loader != null; loader = loader.getParent()) {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(pClassName, pInitialize, loader);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                tried.add(loader);
            }
        }
        return null;
    }

    private static List<ClassLoader> findClassLoaders(ClassLoader ... pClassLoaders) {
        ArrayList<ClassLoader> classLoadersToTry = new ArrayList<ClassLoader>(Arrays.asList(pClassLoaders));
        classLoadersToTry.add(Thread.currentThread().getContextClassLoader());
        classLoadersToTry.add(ClassUtil.class.getClassLoader());
        ArrayList<ClassLoader> ret = new ArrayList<ClassLoader>();
        HashSet<ClassLoader> visited = new HashSet<ClassLoader>();
        for (ClassLoader cll : classLoadersToTry) {
            if (cll == null || visited.contains(cll)) continue;
            ret.add(cll);
            visited.add(cll);
        }
        return ret;
    }

    public static InputStream getResourceAsStream(String pPath) {
        for (ClassLoader loader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassUtil.class.getClassLoader()}) {
            InputStream is;
            if (loader == null || (is = loader.getResourceAsStream(pPath)) == null) continue;
            return is;
        }
        return null;
    }

    public static boolean checkForClass(String pClassName) {
        return ClassUtil.classForName(pClassName, false, new ClassLoader[0]) != null;
    }

    public static <T> T newInstance(String pClassName, Object ... pArguments) {
        Class<T> clazz = ClassUtil.classForName(pClassName, new ClassLoader[0]);
        if (clazz == null) {
            throw new IllegalArgumentException("Cannot find " + pClassName);
        }
        return ClassUtil.newInstance(clazz, pArguments);
    }

    public static <T> T newInstance(Class<T> pClass, Object ... pArguments) {
        try {
            if (pClass != null) {
                if (pArguments.length == 0) {
                    return pClass.newInstance();
                }
                Constructor<T> ctr = ClassUtil.lookupConstructor(pClass, pArguments);
                return ctr.newInstance(pArguments);
            }
            throw new IllegalArgumentException("Given class must not be null");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
    }

    public static Object applyMethod(Object pObject, String pMethod, Object ... pArgs) {
        Class<?> clazz = pObject.getClass();
        try {
            Method method = ClassUtil.extractMethod(pMethod, clazz, pArgs);
            return method.invoke(pObject, pArgs);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot call method " + pMethod + " on " + pObject + ": " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot call method " + pMethod + " on " + pObject + ": " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot call method " + pMethod + " on " + pObject + ": " + e, e);
        }
    }

    public static Set<String> getResources(String pResource) throws IOException {
        List<ClassLoader> clls = ClassUtil.findClassLoaders(new ClassLoader[0]);
        if (clls.size() != 0) {
            HashSet<String> ret = new HashSet<String>();
            for (ClassLoader cll : clls) {
                Enumeration<URL> urlEnum = cll.getResources(pResource);
                ret.addAll(ClassUtil.extractUrlAsStringsFromEnumeration(urlEnum));
            }
            return ret;
        }
        return ClassUtil.extractUrlAsStringsFromEnumeration(ClassLoader.getSystemResources(pResource));
    }

    private static Set<String> extractUrlAsStringsFromEnumeration(Enumeration<URL> urlEnum) {
        HashSet<String> ret = new HashSet<String>();
        while (urlEnum.hasMoreElements()) {
            ret.add(urlEnum.nextElement().toExternalForm());
        }
        return ret;
    }

    private static <T> Constructor<T> lookupConstructor(Class<T> clazz, Object[] pArguments) throws NoSuchMethodException {
        Class[] argTypes = ClassUtil.extractArgumentTypes(pArguments);
        return clazz.getConstructor(argTypes);
    }

    private static Method extractMethod(String pMethod, Class<?> clazz, Object[] pArgs) throws NoSuchMethodException {
        for (Method method : clazz.getMethods()) {
            Class[] parameters;
            if (!method.getName().equals(pMethod) || !ClassUtil.parametersMatch(parameters = method.getParameterTypes(), pArgs)) continue;
            return method;
        }
        throw new NoSuchMethodException("No " + pMethod + " on " + clazz + " with " + pArgs.length + " arguments found ");
    }

    private static Class[] extractArgumentTypes(Object[] pArguments) {
        Class[] argTypes = new Class[pArguments.length];
        int i = 0;
        for (Object arg : pArguments) {
            argTypes[i++] = arg.getClass();
        }
        return argTypes;
    }

    private static boolean parametersMatch(Class[] parameters, Object[] pArgs) {
        if (parameters.length != pArgs.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> argClass;
            Class paramClass;
            if (pArgs[i] == null || (paramClass = parameters[i]).isAssignableFrom(argClass = pArgs[i].getClass()) || ClassUtil.checkForPrimitive(argClass, paramClass)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkForPrimitive(Class argClass, Class paramClass) {
        return paramClass.isPrimitive() && PRIMITIVE_TO_OBJECT_MAP.get(paramClass.getName()) != null;
    }

    static {
        PRIMITIVE_TO_OBJECT_MAP.put("int", Integer.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("long", Long.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("double", Double.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("float", Float.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("bool", Boolean.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("char", Character.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("void", Void.TYPE);
        PRIMITIVE_TO_OBJECT_MAP.put("short", Short.TYPE);
    }
}

