/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(LoopProcessor.class);
    private String id;
    private final Expression expression;
    private final Predicate predicate;
    private final boolean copy;

    public LoopProcessor(Processor processor, Expression expression, Predicate predicate, boolean copy) {
        super(processor);
        this.expression = expression;
        this.predicate = predicate;
        this.copy = copy;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AtomicInteger index = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        AtomicBoolean doWhile = new AtomicBoolean();
        try {
            if (this.expression != null) {
                String text = this.expression.evaluate(exchange, String.class);
                int num = ExchangeHelper.convertToMandatoryType(exchange, Integer.class, text);
                count.set(num);
            } else {
                boolean result = this.predicate.matches(exchange);
                doWhile.set(result);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        Exchange original = exchange;
        Exchange target = exchange;
        if (this.predicate == null) {
            exchange.setProperty("CamelLoopSize", count);
        }
        while (this.predicate != null && doWhile.get() || index.get() < count.get()) {
            target = this.prepareExchange(exchange, index.get(), original);
            boolean sync = this.process(target, callback, index, count, doWhile, original);
            if (!sync) {
                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)target.getExchangeId());
                return false;
            }
            LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)target.getExchangeId());
            if (PipelineHelper.continueProcessing(target, "so breaking out of loop", LOG)) continue;
            break;
        }
        ExchangeHelper.copyResults(exchange, target);
        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        callback.done(true);
        return true;
    }

    protected boolean process(final Exchange exchange, final AsyncCallback callback, final AtomicInteger index, final AtomicInteger count, final AtomicBoolean doWhile, final Exchange original) {
        LOG.debug("LoopProcessor: iteration #{}", (Object)index.get());
        exchange.setProperty("CamelLoopIndex", index.get());
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                index.getAndIncrement();
                if (LoopProcessor.this.predicate != null && index.get() > 0) {
                    try {
                        boolean result = LoopProcessor.this.predicate.matches(exchange);
                        doWhile.set(result);
                    }
                    catch (Exception e) {
                        exchange.setException(e);
                        doWhile.set(false);
                    }
                }
                if (doneSync) {
                    return;
                }
                Exchange target = exchange;
                while ((LoopProcessor.this.predicate != null && doWhile.get() || index.get() < count.get()) && PipelineHelper.continueProcessing(target, "so breaking out of loop", LOG)) {
                    target = LoopProcessor.this.prepareExchange(exchange, index.get(), original);
                    boolean sync = LoopProcessor.this.process(target, callback, index, count, doWhile, original);
                    if (sync) continue;
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)target.getExchangeId());
                    return;
                }
                ExchangeHelper.copyResults(original, target);
                LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                callback.done(false);
            }
        });
        return sync;
    }

    protected Exchange prepareExchange(Exchange exchange, int index, Exchange original) {
        if (this.copy) {
            return ExchangeHelper.createCopy(original, true);
        }
        ExchangeHelper.prepareOutToIn(exchange);
        return exchange;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isCopy() {
        return this.copy;
    }

    @Override
    public String getTraceLabel() {
        if (this.predicate != null) {
            return "loopWhile[" + this.predicate + "]";
        }
        return "loop[" + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        if (this.predicate != null) {
            return "Loop[while: " + this.predicate + " do: " + this.getProcessor() + "]";
        }
        return "Loop[for: " + this.expression + " times do: " + this.getProcessor() + "]";
    }
}

