/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOHelper {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(IOHelper.class);
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final boolean ZERO_BYTE_EOL_ENABLED = "true".equalsIgnoreCase(System.getProperty("camel.zeroByteEOLEnabled", "true"));

    private IOHelper() {
    }

    public static String newStringFromBytes(byte[] bytes) {
        try {
            return new String(bytes, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"UTF-8\") returns invalid name.", e);
        }
    }

    public static String newStringFromBytes(byte[] bytes, int start2, int length) {
        try {
            return new String(bytes, start2, length, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"UTF-8\") returns invalid name.", e);
        }
    }

    public static BufferedInputStream buffered(InputStream in) {
        ObjectHelper.notNull(in, "in");
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream buffered(OutputStream out) {
        ObjectHelper.notNull(out, "out");
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedReader buffered(Reader reader) {
        ObjectHelper.notNull(reader, "reader");
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedWriter buffered(Writer writer) {
        ObjectHelper.notNull(writer, "writer");
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Deprecated
    public static IOException createIOException(Throwable cause) {
        return IOHelper.createIOException(cause.getMessage(), cause);
    }

    @Deprecated
    public static IOException createIOException(String message, Throwable cause) {
        IOException answer = new IOException(message);
        answer.initCause(cause);
        return answer;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOHelper.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOHelper.copy(input, output, bufferSize, false);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean flushOnEachWrite) throws IOException {
        boolean hasData;
        if (input instanceof ByteArrayInputStream) {
            input.mark(0);
            input.reset();
            bufferSize = input.available();
        } else {
            int avail = input.available();
            if (avail > bufferSize) {
                bufferSize = avail;
            }
        }
        if (bufferSize > 262144) {
            bufferSize = 262144;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Copying InputStream: {} -> OutputStream: {} with buffer: {} and flush on each write {}", input, output, bufferSize, flushOnEachWrite);
        }
        int total = 0;
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        if (ZERO_BYTE_EOL_ENABLED) {
            hasData = n > 0;
        } else {
            boolean bl = hasData = n > -1;
        }
        if (hasData) {
            while (-1 != n) {
                output.write(buffer, 0, n);
                if (flushOnEachWrite) {
                    output.flush();
                }
                total += n;
                n = input.read(buffer);
            }
        }
        if (!flushOnEachWrite) {
            output.flush();
        }
        return total;
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        IOHelper.copyAndCloseInput(input, output, 4096);
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        IOHelper.copy(input, output, bufferSize);
        IOHelper.close((Closeable)input, null, LOG);
    }

    public static int copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }

    public static void transfer(ReadableByteChannel input, WritableByteChannel output) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        while (input.read(buffer) >= 0) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                output.write(buffer);
            }
            buffer.clear();
        }
    }

    public static void force(FileChannel channel, String name, Logger log2) {
        try {
            if (channel != null) {
                channel.force(true);
            }
        }
        catch (Exception e) {
            if (log2 == null) {
                log2 = LOG;
            }
            if (name != null) {
                log2.warn("Cannot force FileChannel: " + name + ". Reason: " + e.getMessage(), e);
            }
            log2.warn("Cannot force FileChannel. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void force(FileOutputStream os, String name, Logger log2) {
        try {
            if (os != null) {
                os.getFD().sync();
            }
        }
        catch (Exception e) {
            if (log2 == null) {
                log2 = LOG;
            }
            if (name != null) {
                log2.warn("Cannot sync FileDescriptor: " + name + ". Reason: " + e.getMessage(), e);
            }
            log2.warn("Cannot sync FileDescriptor. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void close(Writer writer, FileOutputStream os, String name, Logger log2, boolean force2) {
        if (writer != null && force2) {
            try {
                writer.flush();
            }
            catch (Exception e) {
                if (log2 == null) {
                    log2 = LOG;
                }
                if (name != null) {
                    log2.warn("Cannot flush Writer: " + name + ". Reason: " + e.getMessage(), e);
                }
                log2.warn("Cannot flush Writer. Reason: {}", (Object)e.getMessage(), (Object)e);
            }
            IOHelper.force(os, name, log2);
        }
        IOHelper.close((Closeable)writer, name, log2);
    }

    public static void close(Closeable closeable, String name, Logger log2) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (log2 == null) {
                    log2 = LOG;
                }
                if (name != null) {
                    log2.warn("Cannot close: " + name + ". Reason: " + e.getMessage(), e);
                }
                log2.warn("Cannot close. Reason: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void closeWithException(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(FileChannel channel, String name, Logger log2, boolean force2) {
        if (force2) {
            IOHelper.force(channel, name, log2);
        }
        IOHelper.close((Closeable)channel, name, log2);
    }

    public static void close(Closeable closeable, String name) {
        IOHelper.close(closeable, name, LOG);
    }

    public static void close(Closeable closeable) {
        IOHelper.close(closeable, null, LOG);
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            IOHelper.close(closeable);
        }
    }

    public static void closeIterator(Object it) throws IOException {
        if (it instanceof java.util.Scanner) {
            java.util.Scanner scanner = (java.util.Scanner)it;
            scanner.close();
            IOException ioException = scanner.ioException();
            if (ioException != null) {
                throw ioException;
            }
        } else if (it instanceof Scanner) {
            Scanner scanner = (Scanner)it;
            scanner.close();
            IOException ioException = scanner.ioException();
            if (ioException != null) {
                throw ioException;
            }
        } else if (it instanceof Closeable) {
            IOHelper.closeWithException((Closeable)it);
        }
    }

    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null && Charset.isSupported(charset)) {
            Charset.forName(charset);
            return;
        }
        throw new UnsupportedCharsetException(charset);
    }

    public static String normalizeCharset(String charset) {
        if (charset != null) {
            String answer = charset.trim();
            if (answer.startsWith("'") || answer.startsWith("\"")) {
                answer = answer.substring(1);
            }
            if (answer.endsWith("'") || answer.endsWith("\"")) {
                answer = answer.substring(0, answer.length() - 1);
            }
            return answer.trim();
        }
        return null;
    }

    public static String getCharsetName(Exchange exchange) {
        return IOHelper.getCharsetName(exchange, true);
    }

    public static String getCharsetName(Exchange exchange, boolean useDefault) {
        if (exchange != null) {
            String charsetName = exchange.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = exchange.getProperty("CamelCharsetName", String.class);
            }
            if (charsetName != null) {
                return IOHelper.normalizeCharset(charsetName);
            }
        }
        if (useDefault) {
            return IOHelper.getDefaultCharsetName();
        }
        return null;
    }

    private static String getDefaultCharsetName() {
        return ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        String string;
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            BufferedReader reader = IOHelper.buffered(isr);
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            IOHelper.close(isr, in);
            throw throwable;
        }
        IOHelper.close(isr, in);
        return string;
    }

    public static String getCharsetNameFromContentType(String contentType) {
        String[] values = contentType.split(";");
        String charset = "";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring(8);
        }
        if ("".equals(charset)) {
            charset = "UTF-8";
        }
        return IOHelper.normalizeCharset(charset);
    }
}

