/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xbean.spring.context.v2.XBeanV2Helper;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBeanBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
        BeanDefinitionParserDelegate delegate = XBeanV2Helper.createParser(readerContext);
        delegate.initDefaults(root);
        return delegate;
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
        BeanDefinitionParserDelegate delegate = XBeanV2Helper.createParser(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }

    protected BeanDefinitionParserDelegate createDelegate(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
        BeanDefinitionParserDelegate delegate = XBeanV2Helper.createParser(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }

    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        String namespaceUri = root.getNamespaceURI();
        if (!DomUtils.nodeNameEquals((Node)root, (String)"beans") && !delegate.isDefaultNamespace(namespaceUri)) {
            try {
                try {
                    Method m = BeanDefinitionParserDelegate.class.getMethod("parseCustomElement", Element.class);
                    m.invoke((Object)delegate, root);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method m = BeanDefinitionParserDelegate.class.getMethod("parseCustomElement", Element.class, Boolean.TYPE);
                        m.invoke((Object)delegate, root, Boolean.FALSE);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        } else if (DomUtils.nodeNameEquals((Node)root, (String)"beans")) {
            NodeList nl = root.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                Element ele = (Element)node;
                String childNamespaceUri = ele.getNamespaceURI();
                if (delegate.isDefaultNamespace(childNamespaceUri)) {
                    this.parseDefaultElement(ele, delegate);
                    continue;
                }
                delegate.parseCustomElement(ele);
            }
        } else {
            super.parseBeanDefinitions(root, delegate);
        }
    }

    private void parseDefaultElement(Element ele, BeanDefinitionParserDelegate delegate) {
        if (DomUtils.nodeNameEquals((Node)ele, (String)"import")) {
            this.importBeanDefinitionResource(ele);
        } else if (DomUtils.nodeNameEquals((Node)ele, (String)"alias")) {
            this.processAliasRegistration(ele);
        } else if (DomUtils.nodeNameEquals((Node)ele, (String)"bean")) {
            this.processBeanDefinition(ele, delegate);
        }
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute("resource");
        if (!StringUtils.hasText((String)location)) {
            this.getReaderContext().error("Resource location must not be empty", (Object)ele);
            return;
        }
        if (ResourcePatternUtils.isUrl((String)(location = SystemPropertyUtils.resolvePlaceholders((String)location)))) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
            }
        } else {
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", (Object)ele, null, (Throwable)ex);
            }
        }
        this.getReaderContext().fireImportProcessed(location, this.extractSource(ele));
    }

    protected void processAliasRegistration(Element ele) {
        String name = ele.getAttribute("name");
        String alias = ele.getAttribute("alias");
        boolean valid = true;
        if (!StringUtils.hasText((String)name)) {
            this.getReaderContext().error("Name must not be empty", (Object)ele);
            valid = false;
        }
        if (!StringUtils.hasText((String)alias)) {
            this.getReaderContext().error("Alias must not be empty", (Object)ele);
            valid = false;
        }
        if (valid) {
            try {
                this.getReaderContext().getRegistry().registerAlias(name, alias);
            }
            catch (BeanDefinitionStoreException ex) {
                this.getReaderContext().error(ex.getMessage(), (Object)ele);
            }
            this.getReaderContext().fireAliasRegistered(name, alias, this.extractSource(ele));
        }
    }

    protected void processBeanDefinition(Element ele, BeanDefinitionParserDelegate delegate) {
        BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(ele);
        if (bdHolder != null) {
            bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getReaderContext().getRegistry());
            this.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(bdHolder));
        }
    }
}

