/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;

public class DebugStore {
    private LinkedList<Entry> debugEntries = new LinkedList();
    private int maxDebugEntries;
    private boolean isDebug;

    public DebugStore(int pMaxDebugEntries, boolean pDebug) {
        this.maxDebugEntries = pMaxDebugEntries;
        this.isDebug = pDebug;
    }

    public void log(String pMessage) {
        if (!this.isDebug) {
            return;
        }
        this.add(System.currentTimeMillis() / 1000L, pMessage);
    }

    public void log(String pMessage, Throwable pThrowable) {
        this.add(System.currentTimeMillis() / 1000L, pMessage, pThrowable);
    }

    public String debugInfo() {
        if (!this.isDebug || this.debugEntries.size() == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = this.debugEntries.size() - 1; i >= 0; --i) {
            Entry entry = this.debugEntries.get(i);
            ret.append(entry.timestamp).append(": ").append(entry.message).append("\n");
            if (entry.throwable == null) continue;
            StringWriter writer = new StringWriter();
            entry.throwable.printStackTrace(new PrintWriter(writer));
            ret.append(writer.toString());
        }
        return ret.toString();
    }

    public void resetDebugInfo() {
        this.debugEntries.clear();
    }

    public void setDebug(boolean pSwitch) {
        if (!pSwitch) {
            this.resetDebugInfo();
        }
        this.isDebug = pSwitch;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public int getMaxDebugEntries() {
        return this.maxDebugEntries;
    }

    public void setMaxDebugEntries(int pNumber) {
        this.maxDebugEntries = pNumber;
        this.trim();
    }

    private synchronized void add(long pTime, String message) {
        this.debugEntries.addFirst(new Entry(pTime, message));
        this.trim();
    }

    private synchronized void add(long pTimestamp, String pMessage, Throwable pThrowable) {
        this.debugEntries.addFirst(new Entry(pTimestamp, pMessage, pThrowable));
        this.trim();
    }

    private synchronized void trim() {
        while (this.debugEntries.size() > this.maxDebugEntries) {
            this.debugEntries.removeLast();
        }
    }

    private static final class Entry {
        private long timestamp;
        private String message;
        private Throwable throwable;

        private Entry(long pTimestamp, String pMessage, Throwable pThrowable) {
            this.timestamp = pTimestamp;
            this.message = pMessage;
            this.throwable = pThrowable;
        }

        private Entry(long pTime, String pMessage) {
            this.timestamp = pTime;
            this.message = pMessage;
        }
    }
}

