/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.journal.JournalMessageStore;
import org.apache.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.activemq.store.journal.JournalTopicMessageStore;

public class JournalTransactionStore
implements TransactionStore {
    private final JournalPersistenceAdapter peristenceAdapter;
    private final Map<Object, Tx> inflightTransactions = new LinkedHashMap<Object, Tx>();
    private final Map<TransactionId, Tx> preparedTransactions = new LinkedHashMap<TransactionId, Tx>();
    private boolean doingRecover;

    public JournalTransactionStore(JournalPersistenceAdapter adapter) {
        this.peristenceAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(TransactionId txid) throws IOException {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            return;
        }
        this.peristenceAdapter.writeCommand((DataStructure)new JournalTransaction(1, txid, false), true);
        map = this.preparedTransactions;
        synchronized (map) {
            this.preparedTransactions.put(txid, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayPrepare(TransactionId txid) throws IOException {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            return;
        }
        map = this.preparedTransactions;
        synchronized (map) {
            this.preparedTransactions.put(txid, tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tx getTx(Object txid, RecordLocation location) {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.get(txid);
        }
        if (tx == null) {
            tx = new Tx(location);
            this.inflightTransactions.put(txid, tx);
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(TransactionId txid, boolean wasPrepared, Runnable preCommit, Runnable postCommit) throws IOException {
        Tx tx;
        if (preCommit != null) {
            preCommit.run();
        }
        if (wasPrepared) {
            Map<TransactionId, Tx> map = this.preparedTransactions;
            synchronized (map) {
                tx = this.preparedTransactions.remove(txid);
            }
        }
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx == null) {
            if (postCommit != null) {
                postCommit.run();
            }
            return;
        }
        if (txid.isXATransaction()) {
            this.peristenceAdapter.writeCommand((DataStructure)new JournalTransaction(2, txid, wasPrepared), true);
        } else {
            this.peristenceAdapter.writeCommand((DataStructure)new JournalTransaction(4, txid, wasPrepared), true);
        }
        if (postCommit != null) {
            postCommit.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tx replayCommit(TransactionId txid, boolean wasPrepared) throws IOException {
        if (wasPrepared) {
            Map<TransactionId, Tx> map = this.preparedTransactions;
            synchronized (map) {
                return this.preparedTransactions.remove(txid);
            }
        }
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            return this.inflightTransactions.remove(txid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(TransactionId txid) throws IOException {
        Tx tx = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            tx = this.inflightTransactions.remove(txid);
        }
        if (tx != null) {
            map = this.preparedTransactions;
            synchronized (map) {
                tx = this.preparedTransactions.remove(txid);
            }
        }
        if (tx != null) {
            if (txid.isXATransaction()) {
                this.peristenceAdapter.writeCommand((DataStructure)new JournalTransaction(3, txid, false), true);
            } else {
                this.peristenceAdapter.writeCommand((DataStructure)new JournalTransaction(5, txid, false), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRollback(TransactionId txid) throws IOException {
        boolean inflight = false;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            inflight = this.inflightTransactions.remove(txid) != null;
        }
        if (inflight) {
            map = this.preparedTransactions;
            synchronized (map) {
                this.preparedTransactions.remove(txid);
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            this.inflightTransactions.clear();
        }
        this.doingRecover = true;
        try {
            LinkedHashMap<TransactionId, Tx> txs = null;
            Map<TransactionId, Tx> map2 = this.preparedTransactions;
            synchronized (map2) {
                txs = new LinkedHashMap<TransactionId, Tx>(this.preparedTransactions);
            }
            for (Object txid : txs.keySet()) {
                Tx tx = (Tx)txs.get(txid);
                listener.recover((XATransactionId)txid, tx.getMessages(), tx.getAcks());
            }
        }
        finally {
            this.doingRecover = false;
        }
    }

    void addMessage(JournalMessageStore store, Message message, RecordLocation location) throws IOException {
        Tx tx = this.getTx(message.getTransactionId(), location);
        tx.add(store, message);
    }

    public void removeMessage(JournalMessageStore store, MessageAck ack, RecordLocation location) throws IOException {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack);
    }

    public void acknowledge(JournalTopicMessageStore store, JournalTopicAck ack, RecordLocation location) {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws IOException {
        RecordLocation location;
        RecordLocation rc = null;
        Map<Object, Tx> map = this.inflightTransactions;
        synchronized (map) {
            for (Tx tx : this.inflightTransactions.values()) {
                location = tx.location;
                if (rc != null && rc.compareTo((Object)location) >= 0) continue;
                rc = location;
            }
        }
        map = this.preparedTransactions;
        synchronized (map) {
            for (Tx tx : this.preparedTransactions.values()) {
                location = tx.location;
                if (rc != null && rc.compareTo((Object)location) >= 0) continue;
                rc = location;
            }
            return rc;
        }
    }

    public boolean isDoingRecover() {
        return this.doingRecover;
    }

    public static class Tx {
        private final RecordLocation location;
        private final ArrayList<TxOperation> operations = new ArrayList();

        public Tx(RecordLocation location) {
            this.location = location;
        }

        public void add(JournalMessageStore store, Message msg) {
            this.operations.add(new TxOperation(0, store, msg));
        }

        public void add(JournalMessageStore store, MessageAck ack) {
            this.operations.add(new TxOperation(1, store, ack));
        }

        public void add(JournalTopicMessageStore store, JournalTopicAck ack) {
            this.operations.add(new TxOperation(3, store, ack));
        }

        public Message[] getMessages() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TxOperation op : this.operations) {
                if (op.operationType != 0) continue;
                list.add(op.data);
            }
            Message[] rc = new Message[list.size()];
            list.toArray(rc);
            return rc;
        }

        public MessageAck[] getAcks() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TxOperation op : this.operations) {
                if (op.operationType != 1) continue;
                list.add(op.data);
            }
            MessageAck[] rc = new MessageAck[list.size()];
            list.toArray(rc);
            return rc;
        }

        public ArrayList<TxOperation> getOperations() {
            return this.operations;
        }
    }

    public static class TxOperation {
        static final byte ADD_OPERATION_TYPE = 0;
        static final byte REMOVE_OPERATION_TYPE = 1;
        static final byte ACK_OPERATION_TYPE = 3;
        public byte operationType;
        public JournalMessageStore store;
        public Object data;

        public TxOperation(byte operationType, JournalMessageStore store, Object data) {
            this.operationType = operationType;
            this.store = store;
            this.data = data;
        }
    }
}

