/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.xa.Xid;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.Lockable;
import org.apache.activemq.broker.LockableServiceSupport;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.filter.AnyDestination;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.NoLocalSubscriptionAware;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.SharedFileLocker;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionIdTransformer;
import org.apache.activemq.store.TransactionIdTransformerAware;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.store.kahadb.MultiKahaDBTransactionStore;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKahaDBPersistenceAdapter
extends LockableServiceSupport
implements PersistenceAdapter,
BrokerServiceAware,
NoLocalSubscriptionAware {
    static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBPersistenceAdapter.class);
    static final ActiveMQDestination matchAll = new AnyDestination(new ActiveMQDestination[]{new ActiveMQQueue(">"), new ActiveMQTopic(">")});
    final int LOCAL_FORMAT_ID_MAGIC = Integer.valueOf(System.getProperty("org.apache.activemq.store.kahadb.MultiKahaDBTransactionStore.localXaFormatId", "61616"));
    final DelegateDestinationMap destinationMap = new DelegateDestinationMap();
    List<PersistenceAdapter> adapters = new CopyOnWriteArrayList<PersistenceAdapter>();
    private File directory = new File(IOHelper.getDefaultDataDirectory() + File.separator + "mKahaDB");
    MultiKahaDBTransactionStore transactionStore = new MultiKahaDBTransactionStore(this);
    TransactionIdTransformer transactionIdTransformer = new TransactionIdTransformer(){

        @Override
        public TransactionId transform(TransactionId txid) {
            if (txid == null) {
                return null;
            }
            if (txid.isLocalTransaction()) {
                final LocalTransactionId t = (LocalTransactionId)txid;
                return new XATransactionId(new Xid(){

                    @Override
                    public int getFormatId() {
                        return MultiKahaDBPersistenceAdapter.this.LOCAL_FORMAT_ID_MAGIC;
                    }

                    @Override
                    public byte[] getGlobalTransactionId() {
                        return t.getConnectionId().getValue().getBytes(Charset.forName("utf-8"));
                    }

                    @Override
                    public byte[] getBranchQualifier() {
                        return Long.toString(t.getValue()).getBytes(Charset.forName("utf-8"));
                    }
                });
            }
            return txid;
        }
    };

    public void setFilteredPersistenceAdapters(List entries) {
        for (Object entry : entries) {
            FilteredKahaDBPersistenceAdapter filteredAdapter = (FilteredKahaDBPersistenceAdapter)entry;
            PersistenceAdapter adapter = filteredAdapter.getPersistenceAdapter();
            if (filteredAdapter.getDestination() == null) {
                filteredAdapter.setDestination(matchAll);
            }
            if (filteredAdapter.isPerDestination()) {
                this.configureDirectory(adapter, null);
                continue;
            }
            this.configureDirectory(adapter, MultiKahaDBPersistenceAdapter.nameFromDestinationFilter(filteredAdapter.getDestination()));
            this.configureAdapter(adapter);
            this.adapters.add(adapter);
        }
        this.destinationMap.setEntries(entries);
    }

    public static String nameFromDestinationFilter(ActiveMQDestination destination) {
        if (destination.getQualifiedName().length() > IOHelper.getMaxFileNameLength()) {
            LOG.warn("Destination name is longer than 'MaximumFileNameLength' system property, potential problem with recovery can result from name truncation.");
        }
        return IOHelper.toFileSystemSafeName(destination.getQualifiedName());
    }

    public boolean isLocalXid(TransactionId xid) {
        return xid instanceof XATransactionId && ((XATransactionId)xid).getFormatId() == this.LOCAL_FORMAT_ID_MAGIC;
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void checkpoint(boolean cleanup) throws IOException {
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.checkpoint(cleanup);
        }
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        PersistenceAdapter persistenceAdapter = this.getMatchingPersistenceAdapter(destination);
        return this.transactionStore.proxy(persistenceAdapter.createTransactionStore(), persistenceAdapter.createQueueMessageStore(destination));
    }

    private PersistenceAdapter getMatchingPersistenceAdapter(ActiveMQDestination destination) throws IOException {
        DestinationMapEntry result = this.destinationMap.chooseValue(destination);
        if (result == null) {
            throw new RuntimeException("No matching persistence adapter configured for destination: " + destination + ", options:" + this.adapters);
        }
        FilteredKahaDBPersistenceAdapter filteredAdapter = (FilteredKahaDBPersistenceAdapter)result;
        if (filteredAdapter.getDestination() == matchAll && filteredAdapter.isPerDestination()) {
            filteredAdapter = this.addAdapter(filteredAdapter, destination);
            if (LOG.isTraceEnabled()) {
                LOG.trace("created per destination adapter for: " + destination + ", " + result);
            }
        }
        this.startAdapter(filteredAdapter.getPersistenceAdapter(), destination.getQualifiedName());
        LOG.debug("destination {} matched persistence adapter {}", (Object)destination.getQualifiedName(), (Object)filteredAdapter.getPersistenceAdapter());
        return filteredAdapter.getPersistenceAdapter();
    }

    private void startAdapter(PersistenceAdapter kahaDBPersistenceAdapter, String destination) {
        try {
            kahaDBPersistenceAdapter.start();
        }
        catch (Exception e) {
            RuntimeException detail = new RuntimeException("Failed to start per destination persistence adapter for destination: " + destination + ", options:" + this.adapters, e);
            LOG.error(detail.toString(), e);
            throw detail;
        }
    }

    private void stopAdapter(PersistenceAdapter kahaDBPersistenceAdapter, String destination) {
        try {
            kahaDBPersistenceAdapter.stop();
        }
        catch (Exception e) {
            RuntimeException detail = new RuntimeException("Failed to stop per destination persistence adapter for destination: " + destination + ", options:" + this.adapters, e);
            LOG.error(detail.toString(), e);
            throw detail;
        }
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        PersistenceAdapter persistenceAdapter = this.getMatchingPersistenceAdapter(destination);
        return this.transactionStore.proxy(persistenceAdapter.createTransactionStore(), persistenceAdapter.createTopicMessageStore(destination));
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.deleteAllMessages();
        }
        this.transactionStore.deleteAllMessages();
        IOHelper.deleteChildren(this.getDirectory());
        for (PersistenceAdapter o : this.destinationMap.get(new AnyDestination(new ActiveMQDestination[]{new ActiveMQQueue(">"), new ActiveMQTopic(">")}))) {
            KahaDBPersistenceAdapter kahaDBPersistenceAdapter;
            if (!(o instanceof FilteredKahaDBPersistenceAdapter)) continue;
            FilteredKahaDBPersistenceAdapter filteredKahaDBPersistenceAdapter = (FilteredKahaDBPersistenceAdapter)((Object)o);
            if (filteredKahaDBPersistenceAdapter.getPersistenceAdapter().getDirectory() != MessageDatabase.DEFAULT_DIRECTORY) {
                IOHelper.deleteChildren(filteredKahaDBPersistenceAdapter.getPersistenceAdapter().getDirectory());
            }
            if (!(filteredKahaDBPersistenceAdapter.getPersistenceAdapter() instanceof KahaDBPersistenceAdapter) || (kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)filteredKahaDBPersistenceAdapter.getPersistenceAdapter()).getIndexDirectory() == null) continue;
            IOHelper.deleteChildren(kahaDBPersistenceAdapter.getIndexDirectory());
        }
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> results = new HashSet<ActiveMQDestination>();
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            results.addAll(persistenceAdapter.getDestinations());
        }
        return results;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        long maxId = -1L;
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            maxId = Math.max(maxId, persistenceAdapter.getLastMessageBrokerSequenceId());
        }
        return maxId;
    }

    @Override
    public long getLastProducerSequenceId(ProducerId id) throws IOException {
        long maxId = -1L;
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            maxId = Math.max(maxId, persistenceAdapter.getLastProducerSequenceId(id));
        }
        return maxId;
    }

    @Override
    public void allowIOResumption() {
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.allowIOResumption();
        }
    }

    @Override
    public void removeQueueMessageStore(ActiveMQQueue destination) {
        PersistenceAdapter adapter = null;
        try {
            adapter = this.getMatchingPersistenceAdapter(destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (adapter instanceof PersistenceAdapter && adapter.getDestinations().isEmpty()) {
            adapter.removeQueueMessageStore(destination);
            this.removeMessageStore(adapter, destination);
            this.destinationMap.remove(destination, adapter);
        }
    }

    @Override
    public void removeTopicMessageStore(ActiveMQTopic destination) {
        PersistenceAdapter adapter = null;
        try {
            adapter = this.getMatchingPersistenceAdapter(destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (adapter instanceof PersistenceAdapter && adapter.getDestinations().isEmpty()) {
            adapter.removeTopicMessageStore(destination);
            this.removeMessageStore(adapter, destination);
            this.destinationMap.remove(destination, adapter);
        }
    }

    private void removeMessageStore(PersistenceAdapter adapter, ActiveMQDestination destination) {
        this.stopAdapter(adapter, destination.toString());
        File adapterDir = adapter.getDirectory();
        if (adapterDir != null) {
            if (IOHelper.deleteFile(adapterDir)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("deleted per destination adapter directory for: " + destination);
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("failed to deleted per destination adapter directory for: " + destination);
            }
        }
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void setBrokerName(String brokerName) {
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setBrokerName(brokerName);
        }
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.setUsageManager(usageManager);
        }
    }

    @Override
    public long size() {
        long size2 = 0L;
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            size2 += persistenceAdapter.size();
        }
        return size2;
    }

    @Override
    public void doStart() throws Exception {
        FilteredKahaDBPersistenceAdapter filteredAdapter;
        DestinationMapEntry result = this.destinationMap.chooseValue(matchAll);
        if (result != null && (filteredAdapter = (FilteredKahaDBPersistenceAdapter)result).getDestination() == matchAll && filteredAdapter.isPerDestination()) {
            this.findAndRegisterExistingAdapters(filteredAdapter);
        }
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            persistenceAdapter.start();
        }
    }

    private void findAndRegisterExistingAdapters(FilteredKahaDBPersistenceAdapter template) throws IOException {
        FileFilter destinationNames = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("queue#") || file.getName().startsWith("topic#");
            }
        };
        File[] candidates = template.getPersistenceAdapter().getDirectory().listFiles(destinationNames);
        if (candidates != null) {
            for (File candidate : candidates) {
                this.registerExistingAdapter(template, candidate);
            }
        }
    }

    private void registerExistingAdapter(FilteredKahaDBPersistenceAdapter filteredAdapter, File candidate) throws IOException {
        PersistenceAdapter adapter = this.adapterFromTemplate(filteredAdapter, candidate.getName());
        this.startAdapter(adapter, candidate.getName());
        Set<ActiveMQDestination> destinations = adapter.getDestinations();
        if (destinations.size() != 0) {
            this.registerAdapter(filteredAdapter, adapter, destinations.toArray(new ActiveMQDestination[0])[0]);
        } else {
            this.stopAdapter(adapter, candidate.getName());
        }
    }

    private FilteredKahaDBPersistenceAdapter addAdapter(FilteredKahaDBPersistenceAdapter filteredAdapter, ActiveMQDestination destination) throws IOException {
        PersistenceAdapter adapter = this.adapterFromTemplate(filteredAdapter, MultiKahaDBPersistenceAdapter.nameFromDestinationFilter(destination));
        return this.registerAdapter(filteredAdapter, adapter, destination);
    }

    private PersistenceAdapter adapterFromTemplate(FilteredKahaDBPersistenceAdapter template, String destinationName) throws IOException {
        PersistenceAdapter adapter = this.kahaDBFromTemplate(template.getPersistenceAdapter());
        this.configureAdapter(adapter);
        this.configureDirectory(adapter, destinationName);
        this.configureIndexDirectory(adapter, template.getPersistenceAdapter(), destinationName);
        return adapter;
    }

    private void configureIndexDirectory(PersistenceAdapter adapter, PersistenceAdapter template, String destinationName) {
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter;
        if (template instanceof KahaDBPersistenceAdapter && (kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)template).getIndexDirectory() != null && adapter instanceof KahaDBPersistenceAdapter) {
            File directory = kahaDBPersistenceAdapter.getIndexDirectory();
            if (destinationName != null) {
                directory = new File(directory, destinationName);
            }
            ((KahaDBPersistenceAdapter)adapter).setIndexDirectory(directory);
        }
    }

    private void configureDirectory(PersistenceAdapter adapter, String fileName) {
        File directory = null;
        File defaultDir = MessageDatabase.DEFAULT_DIRECTORY;
        try {
            defaultDir = ((PersistenceAdapter)adapter.getClass().newInstance()).getDirectory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        directory = defaultDir.equals(adapter.getDirectory()) ? this.getDirectory() : adapter.getDirectory();
        if (fileName != null) {
            directory = new File(directory, fileName);
        }
        adapter.setDirectory(directory);
    }

    private FilteredKahaDBPersistenceAdapter registerAdapter(FilteredKahaDBPersistenceAdapter template, PersistenceAdapter adapter, ActiveMQDestination destination) {
        this.adapters.add(adapter);
        FilteredKahaDBPersistenceAdapter result = new FilteredKahaDBPersistenceAdapter(template, destination, adapter);
        this.destinationMap.put(destination, result);
        return result;
    }

    private void configureAdapter(PersistenceAdapter adapter) {
        ((TransactionIdTransformerAware)((Object)adapter)).setTransactionIdTransformer(this.transactionIdTransformer);
        if (this.isUseLock() && adapter instanceof Lockable) {
            ((Lockable)((Object)adapter)).setUseLock(false);
        }
        if (adapter instanceof BrokerServiceAware) {
            ((BrokerServiceAware)((Object)adapter)).setBrokerService(this.getBrokerService());
        }
    }

    private PersistenceAdapter kahaDBFromTemplate(PersistenceAdapter template) throws IOException {
        try {
            HashMap configuration = new HashMap();
            IntrospectionSupport.getProperties(template, configuration, null);
            PersistenceAdapter adapter = (PersistenceAdapter)template.getClass().newInstance();
            IntrospectionSupport.setProperties(adapter, configuration);
            return adapter;
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            stopper.stop(persistenceAdapter);
        }
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        super.setBrokerService(brokerService);
        for (PersistenceAdapter persistenceAdapter : this.adapters) {
            if (!(persistenceAdapter instanceof BrokerServiceAware)) continue;
            ((BrokerServiceAware)((Object)persistenceAdapter)).setBrokerService(this.getBrokerService());
        }
    }

    public void setTransactionStore(MultiKahaDBTransactionStore transactionStore) {
        this.transactionStore = transactionStore;
    }

    public void setJournalMaxFileLength(int maxFileLength) {
        this.transactionStore.setJournalMaxFileLength(maxFileLength);
    }

    public int getJournalMaxFileLength() {
        return this.transactionStore.getJournalMaxFileLength();
    }

    public void setJournalWriteBatchSize(int journalWriteBatchSize) {
        this.transactionStore.setJournalMaxWriteBatchSize(journalWriteBatchSize);
    }

    public int getJournalWriteBatchSize() {
        return this.transactionStore.getJournalMaxWriteBatchSize();
    }

    public void setJournalCleanupInterval(long journalCleanupInterval) {
        this.transactionStore.setJournalCleanupInterval(journalCleanupInterval);
    }

    public long getJournalCleanupInterval() {
        return this.transactionStore.getJournalCleanupInterval();
    }

    public void setCheckForCorruption(boolean checkForCorruption) {
        this.transactionStore.setCheckForCorruption(checkForCorruption);
    }

    public boolean isCheckForCorruption() {
        return this.transactionStore.isCheckForCorruption();
    }

    public List<PersistenceAdapter> getAdapters() {
        return Collections.unmodifiableList(this.adapters);
    }

    public String toString() {
        String path = this.getDirectory() != null ? this.getDirectory().getAbsolutePath() : "DIRECTORY_NOT_SET";
        return "MultiKahaDBPersistenceAdapter[" + path + "]" + this.adapters;
    }

    @Override
    public Locker createDefaultLocker() throws IOException {
        SharedFileLocker locker = new SharedFileLocker();
        locker.configure(this);
        return locker;
    }

    @Override
    public JobSchedulerStore createJobSchedulerStore() throws IOException, UnsupportedOperationException {
        return new JobSchedulerStoreImpl();
    }

    @Override
    public boolean isPersistNoLocal() {
        return this.brokerService.getStoreOpenWireVersion() >= 11;
    }

    final class DelegateDestinationMap
    extends DestinationMap {
        DelegateDestinationMap() {
        }

        @Override
        public void setEntries(List<DestinationMapEntry> entries) {
            super.setEntries(entries);
        }
    }
}

