/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.annotations;

import java.lang.reflect.Method;
import javax.websocket.CloseReason;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrCallable;
import org.eclipse.jetty.websocket.jsr356.annotations.Param;

public class OnCloseCallable
extends JsrCallable {
    private int idxCloseReason = -1;

    public OnCloseCallable(Class<?> pojo, Method method) {
        super(pojo, method);
    }

    public OnCloseCallable(OnCloseCallable copy) {
        super(copy);
        this.idxCloseReason = copy.idxCloseReason;
    }

    public void call(Object endpoint, CloseInfo close) {
        this.call(endpoint, close.getStatusCode(), close.getReason());
    }

    public void call(Object endpoint, CloseReason closeReason) {
        if (this.idxCloseReason >= 0) {
            this.args[this.idxCloseReason] = closeReason;
        }
        super.call(endpoint, this.args);
    }

    public void call(Object endpoint, int statusCode, String reason) {
        if (this.idxCloseReason >= 0) {
            CloseReason jsrclose = new CloseReason(CloseReason.CloseCodes.getCloseCode(statusCode), reason);
            this.args[this.idxCloseReason] = jsrclose;
        }
        super.call(endpoint, this.args);
    }

    @Override
    public void init(JsrSession session) {
        this.idxCloseReason = this.findIndexForRole(Param.Role.CLOSE_REASON);
        super.init(session);
    }

    @Override
    public void setDecodingType(Class<?> decodingType) {
    }
}

