/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.io.IOException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.exceptions.InternalException;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.linkedin.zookeeper.client.IZooKeeperFactory;
import org.linkedin.zookeeper.client.WatcherChain;
import org.linkedin.zookeeper.client.ZooKeeperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperFactory
implements IZooKeeperFactory {
    public static final String MODULE = ZooKeeperFactory.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final String _connectString;
    private final Timespan _sessionTimeout;
    private final Watcher _watcher;

    public ZooKeeperFactory(String connectString, Timespan sessionTimeout, Watcher watcher) {
        this._connectString = connectString;
        this._sessionTimeout = sessionTimeout;
        this._watcher = watcher;
    }

    public ZooKeeperFactory(String connectString, Timespan sessionTimeout) {
        this(connectString, sessionTimeout, null);
    }

    public IZooKeeper createZooKeeper(Watcher watcher) {
        try {
            return new ZooKeeperImpl(new ZooKeeper(this._connectString, (int)this._sessionTimeout.getDurationInMilliseconds(), WatcherChain.createChain(this._watcher, watcher)));
        }
        catch (IOException e) {
            throw new InternalException(MODULE, (Throwable)e);
        }
    }

    public String getConnectString() {
        return this._connectString;
    }

    public Timespan getSessionTimeout() {
        return this._sessionTimeout;
    }

    public Watcher getWatcher() {
        return this._watcher;
    }
}

