/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,transformation")
@XmlRootElement(name="convertBodyTo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConvertBodyDefinition
extends NoOutputDefinition<ConvertBodyDefinition> {
    @XmlAttribute(required=true)
    private String type;
    @XmlAttribute
    private String charset;
    @XmlTransient
    private Class<?> typeClass;

    public ConvertBodyDefinition() {
    }

    public ConvertBodyDefinition(String type) {
        this.setType(type);
    }

    public ConvertBodyDefinition(Class<?> typeClass) {
        this.setTypeClass(typeClass);
        this.setType(typeClass.getCanonicalName());
    }

    public ConvertBodyDefinition(Class<?> typeClass, String charset) {
        this.setTypeClass(typeClass);
        this.setType(typeClass.getCanonicalName());
        this.setCharset(charset);
    }

    public String toString() {
        return "ConvertBodyTo[" + this.getType() + "]";
    }

    @Override
    public String getShortName() {
        return "convertBodyTo";
    }

    @Override
    public String getLabel() {
        return "convertBodyTo[" + this.getType() + "]";
    }

    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null && Charset.isSupported(charset)) {
            Charset.forName(charset);
            return;
        }
        throw new UnsupportedCharsetException(charset);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.typeClass == null && this.type != null) {
            this.typeClass = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.type);
        }
        if (this.charset != null) {
            ConvertBodyDefinition.validateCharset(this.charset);
        }
        return new ConvertBodyProcessor(this.getTypeClass(), this.getCharset());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

