/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixinRequiredModelMBean
extends RequiredModelMBean {
    private static final Logger LOG = LoggerFactory.getLogger(MixinRequiredModelMBean.class);
    private boolean mask;
    private ModelMBeanInfo defaultMbi;
    private DynamicMBean defaultObject;

    public MixinRequiredModelMBean() throws MBeanException, RuntimeOperationsException {
    }

    public MixinRequiredModelMBean(ModelMBeanInfo mbi, boolean mask, ModelMBeanInfo defaultMbi, DynamicMBean defaultObject) throws MBeanException, RuntimeOperationsException {
        super(mbi);
        this.mask = mask;
        this.defaultMbi = defaultMbi;
        this.defaultObject = defaultObject;
    }

    public boolean isMask() {
        return this.mask;
    }

    @Override
    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        Object answer = this.defaultMbi != null && this.defaultObject != null && this.isDefaultOperation(opName) ? this.defaultObject.invoke(opName, opArgs, sig) : super.invoke(opName, opArgs, sig);
        if (this.mask && answer instanceof String && ObjectHelper.isNotEmpty(answer) && this.isMaskOperation(opName)) {
            answer = this.mask(opName, (String)answer);
        }
        return answer;
    }

    protected boolean isDefaultOperation(String opName) {
        for (MBeanOperationInfo info : this.defaultMbi.getOperations()) {
            if (!info.getName().equals(opName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMaskOperation(String opName) {
        for (MBeanOperationInfo info : this.getMBeanInfo().getOperations()) {
            Descriptor desc;
            if (!info.getName().equals(opName) || (desc = info.getDescriptor()) == null) continue;
            Object val = desc.getFieldValue("mask");
            return val != null && "true".equals(val);
        }
        return false;
    }

    protected String mask(String opName, String value) {
        String answer = URISupport.sanitizeUri(value);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Masking JMX operation: {}.{} value: {} -> {}", this.getMBeanInfo().getClassName(), opName, value, answer);
        }
        return answer;
    }
}

