/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import org.jasypt.spring31.properties.EncryptablePropertyOverrideConfigurer;
import org.jasypt.spring31.xml.encryption.AbstractEncryptablePropertyLoadingBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class EncryptablePropertyOverrideBeanDefinitionParser
extends AbstractEncryptablePropertyLoadingBeanDefinitionParser {
    private static final String ENCRYPTOR_ATTRIBUTE = "encryptor";

    EncryptablePropertyOverrideBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return EncryptablePropertyOverrideConfigurer.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        builder.addPropertyValue("ignoreInvalidKeys", (Object)Boolean.valueOf(element.getAttribute("ignore-unresolvable")));
        String encryptorBeanName = element.getAttribute(ENCRYPTOR_ATTRIBUTE);
        if (StringUtils.hasText((String)encryptorBeanName)) {
            builder.addConstructorArgReference(encryptorBeanName);
        }
    }
}

