/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compactions;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.compaction.CompactionJobPrioritizer;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.tserver.compactions.Compactable;
import org.apache.accumulo.tserver.compactions.CompactionExecutor;
import org.apache.accumulo.tserver.compactions.SubmittedJob;
import org.apache.accumulo.tserver.metrics.CompactionExecutorsMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalCompactionExecutor
implements CompactionExecutor {
    private static final Logger log = LoggerFactory.getLogger(InternalCompactionExecutor.class);
    private PriorityBlockingQueue<Runnable> queue;
    private final CompactionExecutorId ceid;
    private AtomicLong cancelCount = new AtomicLong();
    private ThreadPoolExecutor threadPool;
    private final Set<InternalJob> queuedJob = Collections.synchronizedSet(new HashSet());
    private final CompactionExecutorsMetrics.CeMetrics metricCloser;
    private final RateLimiter readLimiter;
    private final RateLimiter writeLimiter;

    private static CompactionJob getJob(Runnable r) {
        if ((r = TraceUtil.unwrap((Runnable)r)) instanceof InternalJob) {
            return ((InternalJob)r).getJob();
        }
        throw new IllegalArgumentException("Unknown runnable type " + r.getClass().getName());
    }

    InternalCompactionExecutor(CompactionExecutorId ceid, int threads, CompactionExecutorsMetrics ceMetrics, RateLimiter readLimiter, RateLimiter writeLimiter) {
        this.ceid = ceid;
        Comparator<Runnable> comparator = Comparator.comparing(InternalCompactionExecutor::getJob, CompactionJobPrioritizer.JOB_COMPARATOR);
        this.queue = new PriorityBlockingQueue<Runnable>(100, comparator);
        this.threadPool = ThreadPools.getServerThreadPools().createThreadPool(threads, threads, 60L, TimeUnit.SECONDS, "compaction." + ceid, this.queue, false);
        this.metricCloser = ceMetrics.addExecutor(ceid, () -> this.threadPool.getActiveCount(), () -> this.queuedJob.size());
        this.readLimiter = readLimiter;
        this.writeLimiter = writeLimiter;
        log.debug("Created compaction executor {} with {} threads", (Object)ceid, (Object)threads);
    }

    @Override
    public SubmittedJob submit(CompactionServiceId csid, CompactionJob job, Compactable compactable, Consumer<Compactable> completionCallback) {
        Preconditions.checkArgument((boolean)job.getExecutor().equals((Object)this.ceid));
        InternalJob internalJob = new InternalJob(job, compactable, csid, completionCallback);
        this.threadPool.execute(internalJob);
        return internalJob;
    }

    public void setThreads(int numThreads) {
        ThreadPools.resizePool((ThreadPoolExecutor)this.threadPool, () -> numThreads, (String)("compaction." + this.ceid));
    }

    @Override
    public int getCompactionsRunning(CompactionExecutor.CType ctype) {
        if (ctype != CompactionExecutor.CType.INTERNAL) {
            return 0;
        }
        return this.threadPool.getActiveCount();
    }

    @Override
    public int getCompactionsQueued(CompactionExecutor.CType ctype) {
        if (ctype != CompactionExecutor.CType.INTERNAL) {
            return 0;
        }
        return this.queuedJob.size();
    }

    @Override
    public void stop() {
        this.threadPool.shutdownNow();
        log.debug("Stopped compaction executor {}", (Object)this.ceid);
        this.metricCloser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compactableClosed(KeyExtent extent) {
        List<InternalJob> jobToCancel;
        Set<InternalJob> set = this.queuedJob;
        synchronized (set) {
            jobToCancel = this.queuedJob.stream().filter(job -> job.getExtent().equals((Object)extent)).collect(Collectors.toList());
        }
        jobToCancel.forEach(job -> job.cancel(SubmittedJob.Status.QUEUED));
    }

    private class InternalJob
    extends SubmittedJob
    implements Runnable {
        private final AtomicReference<SubmittedJob.Status> status;
        private final Compactable compactable;
        private final CompactionServiceId csid;
        private final Consumer<Compactable> completionCallback;
        private final long queuedTime;

        public InternalJob(CompactionJob job, Compactable compactable, CompactionServiceId csid, Consumer<Compactable> completionCallback) {
            super(job);
            this.status = new AtomicReference<SubmittedJob.Status>(SubmittedJob.Status.QUEUED);
            this.compactable = compactable;
            this.csid = csid;
            this.completionCallback = completionCallback;
            InternalCompactionExecutor.this.queuedJob.add(this);
            this.queuedTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            try {
                if (this.status.compareAndSet(SubmittedJob.Status.QUEUED, SubmittedJob.Status.RUNNING)) {
                    InternalCompactionExecutor.this.queuedJob.remove(this);
                    this.compactable.compact(this.csid, this.getJob(), InternalCompactionExecutor.this.readLimiter, InternalCompactionExecutor.this.writeLimiter, this.queuedTime);
                    this.completionCallback.accept(this.compactable);
                }
            }
            catch (RuntimeException e) {
                log.warn("Compaction failed for {} on {}", new Object[]{this.compactable.getExtent(), this.getJob(), e});
                this.status.compareAndSet(SubmittedJob.Status.RUNNING, SubmittedJob.Status.FAILED);
                this.completionCallback.accept(this.compactable);
            }
            finally {
                this.status.compareAndSet(SubmittedJob.Status.RUNNING, SubmittedJob.Status.COMPLETE);
            }
        }

        @Override
        public SubmittedJob.Status getStatus() {
            return this.status.get();
        }

        @Override
        public boolean cancel(SubmittedJob.Status expectedStatus) {
            boolean canceled = false;
            if (expectedStatus == SubmittedJob.Status.QUEUED) {
                canceled = this.status.compareAndSet(expectedStatus, SubmittedJob.Status.CANCELED);
            }
            if (canceled) {
                InternalCompactionExecutor.this.queuedJob.remove(this);
            }
            if (canceled && InternalCompactionExecutor.this.cancelCount.incrementAndGet() % 1024L == 0L) {
                InternalCompactionExecutor.this.queue.removeIf(runnable -> {
                    if (!((runnable = TraceUtil.unwrap((Runnable)runnable)) instanceof InternalJob)) {
                        throw new IllegalArgumentException("Unknown runnable type " + runnable.getClass().getName());
                    }
                    InternalJob internalJob = (InternalJob)runnable;
                    return internalJob.getStatus() == SubmittedJob.Status.CANCELED;
                });
            }
            return canceled;
        }

        public KeyExtent getExtent() {
            return this.compactable.getExtent();
        }
    }
}

