/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.compactions.external;

import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.accumulo.monitor.rest.compactions.external.ExternalCompactionInfo;

public class CoordinatorInfo {
    public long lastContact;
    public String server;
    public int numQueues;
    public int numCompactors;

    public CoordinatorInfo(Optional<HostAndPort> serverOpt, ExternalCompactionInfo ecInfo) {
        this.server = serverOpt.map(HostAndPort::toString).orElse("none");
        Map<String, List<HostAndPort>> queueToCompactors = ecInfo.getCompactors();
        this.numQueues = queueToCompactors.size();
        this.numCompactors = queueToCompactors.values().stream().mapToInt(List::size).sum();
        this.lastContact = System.currentTimeMillis() - ecInfo.getFetchedTimeMillis();
    }
}

